/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceHandler
implements CodeInsightActionHandler {
    private final boolean myDataFlowToThis;

    public SliceHandler(boolean dataFlowToThis) {
        this.myDataFlowToThis = dataFlowToThis;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement expression2;
        if (project2 == null) {
            SliceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SliceHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            SliceHandler.$$$reportNull$$$0(2);
        }
        if ((expression2 = this.getExpressionAtCaret(editor, file2)) == null) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find what to analyze. Please stand on the expression or variable or method parameter and try again.");
            return;
        }
        SliceManager sliceManager = SliceManager.getInstance(project2);
        sliceManager.slice(expression2, this.myDataFlowToThis, this);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getExpressionAtCaret(Editor editor, PsiFile file2) {
        int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
        if (offset == 0) {
            return null;
        }
        PsiElement atCaret = file2.findElementAt(offset);
        SliceLanguageSupportProvider provider = LanguageSlicing.getProvider((PsiElement)file2);
        if (provider == null) {
            return null;
        }
        return provider.getExpressionAtCaret(atCaret, this.myDataFlowToThis);
    }

    public SliceAnalysisParams askForParams(PsiElement element, boolean dataFlowToThis, SliceManager.StoredSettingsBean storedSettingsBean, String dialogTitle) {
        AnalysisScope analysisScope = new AnalysisScope(element.getContainingFile());
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        Project myProject = element.getProject();
        AnalysisUIOptions analysisUIOptions = new AnalysisUIOptions();
        analysisUIOptions.save(storedSettingsBean.analysisUIOptions);
        BaseAnalysisActionDialog dialog2 = new BaseAnalysisActionDialog(dialogTitle, "Analyze scope", myProject, analysisScope, module2, true, analysisUIOptions, element);
        if (!dialog2.showAndGet()) {
            return null;
        }
        AnalysisScope scope = dialog2.getScope(analysisUIOptions, analysisScope, myProject, module2);
        storedSettingsBean.analysisUIOptions.save(analysisUIOptions);
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.scope = scope;
        params.dataFlowToThis = dataFlowToThis;
        return params;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/slicer/SliceHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

