/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.spellchecker.BaseSuggestionProvider;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.dictionary.AggregatedDictionary;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SpellCheckerFactory;
import com.intellij.spellchecker.engine.SuggestionProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.state.AggregatedDictionaryState;
import com.intellij.spellchecker.util.SPFileUtil;
import com.intellij.spellchecker.util.Strings;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.SpellCheckerManager");
    private static final int MAX_SUGGESTIONS_THRESHOLD = 5;
    private static final int MAX_METRICS = 1;
    private final Project project;
    private SpellCheckerEngine spellChecker;
    private AggregatedDictionary userDictionary;
    private final SuggestionProvider suggestionProvider = new BaseSuggestionProvider(this);
    private final SpellCheckerSettings settings;
    private final VirtualFileListener myCustomDictFileListener;

    public static SpellCheckerManager getInstance(Project project2) {
        return (SpellCheckerManager)ServiceManager.getService((Project)project2, SpellCheckerManager.class);
    }

    public SpellCheckerManager(Project project2, SpellCheckerSettings settings) {
        this.project = project2;
        this.settings = settings;
        this.fullConfigurationReload();
        Disposer.register((Disposable)project2, (Disposable)this);
        this.myCustomDictFileListener = new CustomDictFileListener(settings);
        LocalFileSystem.getInstance().addVirtualFileListener(this.myCustomDictFileListener);
    }

    public void fullConfigurationReload() {
        this.spellChecker = SpellCheckerFactory.create(this.project);
        this.fillEngineDictionary();
    }

    public void updateBundledDictionaries(List<String> removedDictionaries) {
        for (BundledDictionaryProvider provider : (BundledDictionaryProvider[])Extensions.getExtensions(BundledDictionaryProvider.EP_NAME)) {
            for (String dictionary : provider.getBundledDictionaries()) {
                boolean dictionaryShouldBeLoad = this.settings == null || !this.settings.getBundledDisabledDictionariesPaths().contains(dictionary);
                boolean dictionaryIsLoad = this.spellChecker.isDictionaryLoad(dictionary);
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    this.spellChecker.removeDictionary(dictionary);
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                Class<?> loaderClass = provider.getClass();
                InputStream stream = loaderClass.getResourceAsStream(dictionary);
                if (stream != null) {
                    this.spellChecker.loadDictionary(new StreamLoader(stream, dictionary));
                    continue;
                }
                LOG.warn("Couldn't load dictionary '" + dictionary + "' with loader '" + loaderClass + "'");
            }
        }
        if (this.settings != null && this.settings.getDictionaryFoldersPaths() != null) {
            Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String folder : this.settings.getDictionaryFoldersPaths()) {
                SPFileUtil.processFilesRecursively(folder, (Consumer<String>)((Consumer)s -> {
                    boolean dictionaryShouldBeLoad = !disabledDictionaries.contains(s);
                    boolean dictionaryIsLoad = this.spellChecker.isDictionaryLoad((String)s);
                    if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                        this.spellChecker.removeDictionary((String)s);
                    } else if (!dictionaryIsLoad && dictionaryShouldBeLoad) {
                        this.loadDictionary((String)s);
                    }
                }));
            }
        }
        if (!ContainerUtil.isEmpty(removedDictionaries)) {
            for (String name2 : removedDictionaries) {
                this.spellChecker.removeDictionary(name2);
            }
        }
        SpellCheckerManager.restartInspections();
    }

    public Project getProject() {
        return this.project;
    }

    public EditableDictionary getUserDictionary() {
        return this.userDictionary;
    }

    private void fillEngineDictionary() {
        this.spellChecker.reset();
        for (BundledDictionaryProvider provider : (BundledDictionaryProvider[])Extensions.getExtensions(BundledDictionaryProvider.EP_NAME)) {
            for (String dictionary : provider.getBundledDictionaries()) {
                if (this.settings != null && this.settings.getBundledDisabledDictionariesPaths().contains(dictionary)) continue;
                Class<?> loaderClass = provider.getClass();
                InputStream stream = loaderClass.getResourceAsStream(dictionary);
                if (stream != null) {
                    this.spellChecker.loadDictionary(new StreamLoader(stream, dictionary));
                    continue;
                }
                LOG.warn("Couldn't load dictionary '" + dictionary + "' with loader '" + loaderClass + "'");
            }
        }
        if (this.settings != null && this.settings.getDictionaryFoldersPaths() != null) {
            Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String folder : this.settings.getDictionaryFoldersPaths()) {
                SPFileUtil.processFilesRecursively(folder, (Consumer<String>)((Consumer)s -> {
                    if (!disabledDictionaries.contains(s)) {
                        this.loadDictionary((String)s);
                    }
                }));
            }
        }
        AggregatedDictionaryState dictionaryState = (AggregatedDictionaryState)ServiceManager.getService((Project)this.project, AggregatedDictionaryState.class);
        dictionaryState.addDictStateListener(dict -> SpellCheckerManager.restartInspections());
        this.userDictionary = dictionaryState.getDictionary();
        this.spellChecker.addModifiableDictionary(this.userDictionary);
    }

    private void loadDictionary(String path) {
        CustomDictionaryProvider dictionaryProvider = SpellCheckerManager.findApplicable(path);
        if (dictionaryProvider != null) {
            Dictionary dictionary = dictionaryProvider.get(path);
            if (dictionary != null) {
                this.spellChecker.addDictionary(dictionary);
            }
        } else {
            this.spellChecker.loadDictionary(new FileLoader(path));
        }
    }

    public boolean hasProblem(@NotNull String word) {
        if (word == null) {
            SpellCheckerManager.$$$reportNull$$$0(0);
        }
        return !this.spellChecker.isCorrect(word);
    }

    public void acceptWordAsCorrect(@NotNull String word, Project project2) {
        String transformed;
        if (word == null) {
            SpellCheckerManager.$$$reportNull$$$0(1);
        }
        if ((transformed = this.spellChecker.getTransformation().transform(word)) != null) {
            this.userDictionary.addToDictionary(transformed);
            PsiModificationTrackerImpl modificationTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project2).getModificationTracker();
            modificationTracker.incCounter();
        }
    }

    public void updateUserDictionary(@Nullable Collection<String> words) {
        this.userDictionary.replaceAll(words);
        SpellCheckerManager.restartInspections();
    }

    @NotNull
    public static List<String> getBundledDictionaries() {
        ArrayList<String> dictionaries = new ArrayList<String>();
        for (BundledDictionaryProvider provider : (BundledDictionaryProvider[])Extensions.getExtensions(BundledDictionaryProvider.EP_NAME)) {
            ContainerUtil.addAll(dictionaries, (Object[])provider.getBundledDictionaries());
        }
        ArrayList<String> arrayList = dictionaries;
        if (arrayList == null) {
            SpellCheckerManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getSuggestions(@NotNull String text2) {
        if (text2 == null) {
            SpellCheckerManager.$$$reportNull$$$0(3);
        }
        List<String> list2 = this.suggestionProvider.getSuggestions(text2);
        if (list2 == null) {
            SpellCheckerManager.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    protected List<String> getRawSuggestions(@NotNull String word) {
        ArrayList<String> suggestions;
        if (word == null) {
            SpellCheckerManager.$$$reportNull$$$0(5);
        }
        if (!this.spellChecker.isCorrect(word) && !(suggestions = this.spellChecker.getSuggestions(word, 5, 1)).isEmpty()) {
            if (Strings.isCapitalized(word)) {
                Strings.capitalize(suggestions);
            } else if (Strings.isUpperCase(word)) {
                Strings.upperCase(suggestions);
            }
            LinkedHashSet<String> unique = new LinkedHashSet<String>(suggestions);
            ArrayList<String> arrayList = unique.size() < suggestions.size() ? new ArrayList<String>(unique) : suggestions;
            if (arrayList == null) {
                SpellCheckerManager.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            SpellCheckerManager.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public static void restartInspections() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project[] projects;
            for (Project project1 : projects = ProjectManager.getInstance().getOpenProjects()) {
                if (!project1.isInitialized() || !project1.isOpen() || project1.isDefault()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project1).restart();
            }
        });
    }

    @Nullable
    private static CustomDictionaryProvider findApplicable(@NotNull String path) {
        if (path == null) {
            SpellCheckerManager.$$$reportNull$$$0(8);
        }
        return Stream.of(Extensions.getExtensions(CustomDictionaryProvider.EP_NAME)).filter(dictionaryProvider -> {
            if (path == null) {
                SpellCheckerManager.$$$reportNull$$$0(9);
            }
            return dictionaryProvider.isApplicable(path);
        }).findAny().orElse(null);
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myCustomDictFileListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/SpellCheckerManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/SpellCheckerManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledDictionaries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawSuggestions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasProblem";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptWordAsCorrect";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRawSuggestions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findApplicable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findApplicable$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CustomDictFileListener
    implements VirtualFileListener {
        private final SpellCheckerSettings mySettings;

        public CustomDictFileListener(SpellCheckerSettings settings) {
            if (settings == null) {
                CustomDictFileListener.$$$reportNull$$$0(0);
            }
            this.mySettings = settings;
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(1);
            }
            this.removeCustomDictionaries(event.getFile().getPath());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(2);
            }
            this.loadCustomDictionaries(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            String oldPath;
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(3);
            }
            if (!this.locatedInDictFolders(oldPath = event.getOldParent().getPath())) {
                this.loadCustomDictionaries(event.getFile());
            } else {
                String newPath = event.getNewParent().getPath();
                if (!this.locatedInDictFolders(newPath)) {
                    this.removeCustomDictionaries(oldPath + File.separator + event.getFileName());
                }
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(4);
            }
            String path = FileUtilRt.toSystemDependentName((String)event.getFile().getPath());
            if (!SpellCheckerManager.this.spellChecker.isDictionaryLoad(path) || this.mySettings.getDisabledDictionariesPaths().contains(path)) {
                return;
            }
            SpellCheckerManager.this.spellChecker.removeDictionary(path);
            SpellCheckerManager.this.loadDictionary(path);
            SpellCheckerManager.restartInspections();
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file2;
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(5);
            }
            if ((file2 = event.getFile()).isDirectory()) {
                return;
            }
            if ("name".equals(event.getPropertyName())) {
                String oldName = (String)event.getOldValue();
                if (!this.isDic(oldName)) {
                    this.loadCustomDictionaries(file2);
                } else {
                    String newName = (String)event.getNewValue();
                    if (!this.isDic(newName)) {
                        this.removeCustomDictionaries(file2.getParent().getPath() + File.separator + oldName);
                    }
                }
            }
        }

        private void removeCustomDictionaries(@NotNull String path) {
            if (path == null) {
                CustomDictFileListener.$$$reportNull$$$0(6);
            }
            path = FileUtilRt.toSystemDependentName((String)path);
            if (SpellCheckerManager.this.spellChecker.isDictionaryLoad(path)) {
                SpellCheckerManager.this.spellChecker.removeDictionary(path);
                SpellCheckerManager.restartInspections();
            } else if (this.locatedInDictFolders(path)) {
                SpellCheckerManager.this.spellChecker.removeDictionariesRecursively(path);
                SpellCheckerManager.restartInspections();
            }
            if (this.mySettings.getDictionaryFoldersPaths().contains(path)) {
                this.mySettings.getDictionaryFoldersPaths().remove(path);
            }
        }

        private void loadCustomDictionaries(@NotNull VirtualFile file2) {
            String path;
            if (file2 == null) {
                CustomDictFileListener.$$$reportNull$$$0(7);
            }
            if (!this.locatedInDictFolders(path = FileUtilRt.toSystemDependentName((String)file2.getPath()))) {
                return;
            }
            if (file2.isDirectory()) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file2) {
                        if (file2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        boolean isDirectory = file2.isDirectory();
                        String path = file2.getPath();
                        if (!isDirectory && CustomDictFileListener.this.isDic(path)) {
                            SpellCheckerManager.this.loadDictionary(path);
                            SpellCheckerManager.restartInspections();
                        }
                        return isDirectory;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spellchecker/SpellCheckerManager$CustomDictFileListener$1", "visitFile"));
                    }
                });
            } else if (this.isDic(path)) {
                SpellCheckerManager.this.loadDictionary(path);
                SpellCheckerManager.restartInspections();
            }
        }

        private boolean isDic(String path) {
            return FileUtilRt.extensionEquals((String)path, (String)"dic");
        }

        private boolean locatedInDictFolders(@NotNull String path) {
            if (path == null) {
                CustomDictFileListener.$$$reportNull$$$0(8);
            }
            return this.mySettings.getDictionaryFoldersPaths().stream().anyMatch(dicFolderPath -> {
                if (path == null) {
                    CustomDictFileListener.$$$reportNull$$$0(9);
                }
                return FileUtil.isAncestor((String)dicFolderPath, (String)path, (boolean)false);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spellchecker/SpellCheckerManager$CustomDictFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeCustomDictionaries";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadCustomDictionaries";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "locatedInDictFolders";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$locatedInDictFolders$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

