/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.spellchecker.compress.Alphabet;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class UnitBitSet {
    static final int MAX_CHARS_IN_WORD = 64;
    static final int MAX_UNIT_VALUE = 255;
    final byte[] b;
    private final Alphabet alpha;

    UnitBitSet(@NotNull byte[] indices2, @NotNull Alphabet alphabet) {
        if (indices2 == null) {
            UnitBitSet.$$$reportNull$$$0(0);
        }
        if (alphabet == null) {
            UnitBitSet.$$$reportNull$$$0(1);
        }
        this.b = indices2;
        this.alpha = alphabet;
    }

    int getUnitValue(int number) {
        int r = this.b[number] & 0xFF;
        assert (r >= 0 && r <= 255) : "invalid unit value";
        return r;
    }

    void setUnitValue(int number, int value2) {
        assert (value2 >= 0) : "unit value is negative" + value2;
        assert (value2 <= 255) : "unit value is too big";
        this.b[number] = (byte)value2;
    }

    public boolean equals(Object obj) {
        return obj instanceof UnitBitSet && Arrays.equals(this.b, ((UnitBitSet)obj).b);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (byte aB : this.b) {
            s.append(Integer.toHexString(aB & 0xFF));
        }
        return s.toString();
    }

    @NotNull
    public byte[] pack() {
        int meaningfulBits = 32 - Integer.numberOfLeadingZeros(this.alpha.getLastIndexUsed());
        assert (meaningfulBits <= 8 && meaningfulBits >= 1) : meaningfulBits + ": " + this.alpha;
        byte[] result2 = new byte[(this.b.length * meaningfulBits + 7) / 8];
        int byteNumber = 0;
        int bitOffset = 0;
        for (byte index : this.b) {
            int bitsToChip = Math.min(8 - bitOffset, meaningfulBits);
            int n = byteNumber++;
            result2[n] = (byte)(result2[n] | (index & (1 << bitsToChip) - 1) << bitOffset);
            int bitsLeft = meaningfulBits - bitsToChip;
            if (bitsLeft > 0) {
                int n2 = byteNumber;
                result2[n2] = (byte)(result2[n2] | index >> bitsToChip & (1 << bitsLeft) - 1);
                bitOffset = bitsLeft;
                continue;
            }
            bitOffset += bitsToChip;
        }
        if (result2 == null) {
            UnitBitSet.$$$reportNull$$$0(2);
        }
        return result2;
    }

    @NotNull
    public static String decode(@NotNull byte[] packed, @NotNull Alphabet alphabet) {
        if (packed == null) {
            UnitBitSet.$$$reportNull$$$0(3);
        }
        if (alphabet == null) {
            UnitBitSet.$$$reportNull$$$0(4);
        }
        String string = UnitBitSet.decode(packed, 0, packed.length, alphabet);
        if (string == null) {
            UnitBitSet.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String decode(@NotNull byte[] packed, int from, int to, @NotNull Alphabet alphabet) {
        int index;
        char letter;
        if (packed == null) {
            UnitBitSet.$$$reportNull$$$0(6);
        }
        if (alphabet == null) {
            UnitBitSet.$$$reportNull$$$0(7);
        }
        int meaningfulBits = 32 - Integer.numberOfLeadingZeros(alphabet.getLastIndexUsed());
        assert (meaningfulBits <= 8) : alphabet;
        StringBuilder result2 = new StringBuilder((to - from) * 8 / meaningfulBits);
        int curByte = packed[from];
        int byteIndex = from;
        int bitOffset = 0;
        while (byteIndex < to && (letter = alphabet.getLetter(index = curByte & (1 << meaningfulBits) - 1)) != '\u0000') {
            result2.append(letter);
            curByte >>>= meaningfulBits;
            assert ((bitOffset += meaningfulBits) <= 8) : alphabet;
            if (bitOffset + meaningfulBits <= 8) continue;
            if (++byteIndex == to) break;
            int leftOverBits = 8 - bitOffset;
            curByte = packed[byteIndex] << leftOverBits | curByte & (1 << leftOverBits) - 1;
            bitOffset = -leftOverBits;
        }
        String string = result2.toString();
        if (string == null) {
            UnitBitSet.$$$reportNull$$$0(8);
        }
        return string;
    }

    static int getFirstLetterIndex(byte firstPackedByte, @NotNull Alphabet alphabet) {
        if (alphabet == null) {
            UnitBitSet.$$$reportNull$$$0(9);
        }
        int meaningfulBits = 32 - Integer.numberOfLeadingZeros(alphabet.getLastIndexUsed());
        assert (meaningfulBits <= 8) : alphabet;
        int index = firstPackedByte & (1 << meaningfulBits) - 1;
        return index;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alphabet";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/compress/UnitBitSet";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/compress/UnitBitSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "pack";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLetterIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

