/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.WordSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextSplitter
extends BaseSplitter {
    private static final TextSplitter INSTANCE = new TextSplitter();
    private static final Pattern EXTENDED_WORD_AND_SPECIAL = Pattern.compile("(&[^;]+;)|(([#]|0x[0-9]*)?\\p{L}+'?\\p{L}[_\\p{L}]*)");

    public static TextSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text2, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (range == null) {
            TextSplitter.$$$reportNull$$$0(0);
        }
        if (text2 == null || StringUtil.isEmpty((String)text2)) {
            return;
        }
        this.doSplit(text2, range, consumer);
    }

    protected void doSplit(@NotNull String text2, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (text2 == null) {
            TextSplitter.$$$reportNull$$$0(1);
        }
        if (range == null) {
            TextSplitter.$$$reportNull$$$0(2);
        }
        WordSplitter ws = WordSplitter.getInstance();
        Matcher matcher = EXTENDED_WORD_AND_SPECIAL.matcher(text2);
        matcher.region(range.getStartOffset(), range.getEndOffset());
        while (matcher.find()) {
            TextRange found = new TextRange(matcher.start(), matcher.end());
            ws.split(text2, found, consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/inspections/TextSplitter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "split";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doSplit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

