/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import java.util.Set;

public class DictionarySuggestionProvider
extends PreferrableNameSuggestionProvider {
    private boolean active;

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean shouldCheckOthers() {
        return !this.active;
    }

    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, Set<String> result2) {
        assert (result2 != null);
        if (!this.active || nameSuggestionContext == null) {
            return null;
        }
        String text2 = nameSuggestionContext.getText();
        if (nameSuggestionContext instanceof PsiNamedElement) {
            text2 = ((PsiNamedElement)element).getName();
        }
        if (text2 == null) {
            return null;
        }
        Project project2 = element.getProject();
        SpellCheckerManager manager = SpellCheckerManager.getInstance(project2);
        manager.getSuggestions(text2).stream().filter(newName -> RenameUtil.isValidName(project2, element, newName)).forEach(result2::add);
        return SuggestedNameInfo.NULL_INFO;
    }
}

