/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfile {
    public static final ExtensionPointName<StructuralSearchProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.structuralsearch.profile");

    public abstract void compile(PsiElement[] var1, @NotNull GlobalCompilingVisitor var2);

    @NotNull
    public abstract PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor var1);

    @NotNull
    public abstract NodeFilter getLexicalNodesFilter();

    @NotNull
    public abstract CompiledPattern createCompiledPattern();

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text2, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, @Nullable String contextName, @Nullable String extension, @NotNull Project project2, boolean physical) {
        if (text2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(0);
        }
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(1);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(3);
        }
        String ext = extension != null ? extension : fileType.getDefaultExtension();
        String name2 = "__dummy." + ext;
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        PsiFile file2 = language == null ? factory.createFileFromText(name2, fileType, (CharSequence)text2, LocalTimeCounter.currentTime(), physical, true) : factory.createFileFromText(name2, language, (CharSequence)text2, physical, true);
        PsiElement[] psiElementArray = file2 != null ? file2.getChildren() : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            StructuralSearchProfile.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text2, @NotNull PatternTreeContext context, @NotNull FileType fileType, @NotNull Project project2, boolean physical) {
        if (text2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(5);
        }
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(8);
        }
        PsiElement[] psiElementArray = this.createPatternTree(text2, context, fileType, null, null, null, project2, physical);
        if (psiElementArray == null) {
            StructuralSearchProfile.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    @NotNull
    public Editor createEditor(@NotNull SearchContext searchContext, @NotNull FileType fileType, Language dialect, String text2, boolean useLastConfiguration) {
        PsiCodeFragment codeFragment;
        if (searchContext == null) {
            StructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(11);
        }
        if ((codeFragment = this.createCodeFragment(searchContext.getProject(), text2, null)) == null) {
            codeFragment = StructuralSearchProfile.createFileFragment(searchContext, fileType, dialect, text2);
        }
        if (codeFragment != null) {
            Document doc = PsiDocumentManager.getInstance((Project)searchContext.getProject()).getDocument((PsiFile)codeFragment);
            assert (doc != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)searchContext.getProject()).setHighlightingEnabled((PsiFile)codeFragment, false);
            Editor editor = UIUtil.createEditor(doc, searchContext.getProject(), true, true, this.getTemplateContextType());
            if (editor == null) {
                StructuralSearchProfile.$$$reportNull$$$0(12);
            }
            return editor;
        }
        EditorFactory factory = EditorFactory.getInstance();
        Document document = factory.createDocument((CharSequence)text2);
        EditorEx editor = (EditorEx)factory.createEditor(document, searchContext.getProject());
        editor.getSettings().setFoldingOutlineShown(false);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            StructuralSearchProfile.$$$reportNull$$$0(13);
        }
        return editorEx;
    }

    private static PsiFile createFileFragment(SearchContext searchContext, FileType fileType, Language dialect, String text2) {
        String name2 = "__dummy." + fileType.getDefaultExtension();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)searchContext.getProject());
        return dialect == null ? factory.createFileFromText(name2, fileType, (CharSequence)text2, LocalTimeCounter.currentTime(), true, true) : factory.createFileFromText(name2, dialect, (CharSequence)text2, true, true);
    }

    @Nullable
    public PsiCodeFragment createCodeFragment(Project project2, String text2, @Nullable PsiElement context) {
        return null;
    }

    @Nullable
    public abstract Class<? extends TemplateContextType> getTemplateContextTypeClass();

    public final TemplateContextType getTemplateContextType() {
        Class<? extends TemplateContextType> clazz = this.getTemplateContextTypeClass();
        return clazz != null ? (TemplateContextType)ContainerUtil.findInstance((Object[])TemplateContextType.EP_NAME.getExtensions(), clazz) : null;
    }

    @Nullable
    public FileType detectFileType(@NotNull PsiElement context) {
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(14);
        }
        return null;
    }

    @Nullable
    public StructuralReplaceHandler getReplaceHandler(@NotNull ReplacementContext context) {
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(15);
        }
        return null;
    }

    public void checkSearchPattern(Project project2, MatchOptions options) {
    }

    public void checkReplacementPattern(Project project2, ReplaceOptions options) {
        String fileType = options.getMatchOptions().getFileType().getName().toLowerCase();
        throw new UnsupportedPatternException(SSRBundle.message("replacement.not.supported.for.filetype", fileType));
    }

    public boolean canBeVarDelimeter(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchProfile.$$$reportNull$$$0(16);
        }
        return false;
    }

    public String getText(PsiElement match, int start, int end) {
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    public Class getElementContextByPsi(PsiElement element) {
        return element.getClass();
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        String name2;
        if (element instanceof PsiNamedElement && (name2 = ((PsiNamedElement)element).getName()) != null) {
            String string = name2;
            if (string == null) {
                StructuralSearchProfile.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(18);
        }
        return string;
    }

    public String getMeaningfulText(PsiElement element) {
        return this.getTypedVarString(element);
    }

    public PsiElement updateCurrentNode(PsiElement node) {
        return node;
    }

    public PsiElement extendMatchedByDownUp(PsiElement node) {
        return node;
    }

    public PsiElement extendMatchOnePsiFile(PsiElement file2) {
        return file2;
    }

    public LanguageFileType getDefaultFileType(@Nullable LanguageFileType fileType) {
        return fileType;
    }

    public Configuration[] getPredefinedTemplates() {
        return Configuration.EMPTY_ARRAY;
    }

    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, ReplaceOptions options, ReplacementBuilder builder) {
        if (node == null) {
            StructuralSearchProfile.$$$reportNull$$$0(19);
        }
    }

    public int handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result2, int offset, ReplacementInfo replacementInfo) {
        if (info.getName().equals(match.getName())) {
            String replacementString = match.getMatchImage();
            boolean forceAddingNewLine = false;
            if (match.hasSons() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                for (MatchResult matchResult : match.getAllSons()) {
                    PsiElement currentElement = matchResult.getMatch();
                    if (buf.length() > 0) {
                        if (info.isArgumentContext()) {
                            buf.append(',');
                        } else {
                            buf.append(' ');
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    forceAddingNewLine = currentElement instanceof PsiComment;
                }
                replacementString = buf.toString();
            } else if (info.isStatementContext()) {
                forceAddingNewLine = match.getMatch() instanceof PsiComment;
            }
            offset = Replacer.insertSubstitution(result2, offset, info, replacementString);
            if (forceAddingNewLine && info.isStatementContext()) {
                result2.insert(info.getStartIndex() + offset + 1, '\n');
                ++offset;
            }
        }
        return offset;
    }

    public int handleNoSubstitution(ParameterInfo info, int offset, StringBuilder result2) {
        if (info.isHasCommaBefore()) {
            result2.delete(info.getBeforeDelimiterPos() + offset, info.getBeforeDelimiterPos() + 1 + offset);
            --offset;
        } else if (info.isHasCommaAfter()) {
            result2.delete(info.getAfterDelimiterPos() + offset, info.getAfterDelimiterPos() + 1 + offset);
            --offset;
        }
        return offset;
    }

    public boolean isIdentifier(PsiElement element) {
        return false;
    }

    @NotNull
    public Collection<String> getReservedWords() {
        Set<String> set2 = Collections.emptySet();
        if (set2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(20);
        }
        return set2;
    }

    public boolean isDocCommentOwner(PsiElement match) {
        return false;
    }

    @NotNull
    public PsiElement getPresentableElement(PsiElement element) {
        PsiElement psiElement = this.isIdentifier(element) ? element.getParent() : element;
        if (psiElement == null) {
            StructuralSearchProfile.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedWords";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canBeVarDelimeter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "provideAdditionalReplaceOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

