/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Replacer {
    private final Project project;
    private ReplacementBuilder replacementBuilder;
    private ReplaceOptions options;
    private ReplacementContext context;
    private StructuralReplaceHandler replaceHandler;
    private PsiElement lastAffectedElement = null;

    public Replacer(Project project2, ReplaceOptions options) {
        this.project = project2;
        this.options = options;
    }

    public static String stripTypedVariableDecoration(String type2) {
        return type2.substring(1, type2.length() - 1);
    }

    public static int insertSubstitution(StringBuilder result2, int offset, ParameterInfo info, String image) {
        if (image.length() > 0) {
            result2.insert(offset + info.getStartIndex(), image);
        }
        return offset += image.length();
    }

    public String testReplace(String in, String what, String by, ReplaceOptions options) throws IncorrectOperationException {
        return this.testReplace(in, what, by, options, false);
    }

    public String testReplace(String in, String what, String by, ReplaceOptions options, boolean filePattern) {
        FileType type2 = options.getMatchOptions().getFileType();
        return this.testReplace(in, what, by, options, filePattern, false, type2, null);
    }

    public String testReplace(String in, String what, String by, ReplaceOptions options, boolean filePattern, boolean createPhysicalFile, FileType sourceFileType, Language sourceDialect) {
        this.options = options;
        MatchOptions matchOptions = this.options.getMatchOptions();
        this.options.setReplacement(by);
        this.replacementBuilder = null;
        this.context = null;
        this.replaceHandler = null;
        matchOptions.clearVariableConstraints();
        matchOptions.fillSearchCriteria(what);
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(matchOptions.getFileType());
        assert (profile2 != null);
        profile2.checkSearchPattern(this.project, matchOptions);
        Replacer.checkSupportedReplacementPattern(this.project, options);
        Matcher matcher = new Matcher(this.project);
        try {
            PsiElement nextSibling;
            PsiElement parent;
            PsiElement lastElement;
            PsiElement firstElement;
            if (options.getMatchOptions().getScope() == null) {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(in, filePattern ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, sourceDialect, null, this.project, createPhysicalFile);
                firstElement = elements[0];
                lastElement = elements[elements.length - 1];
                parent = firstElement.getParent();
                matchOptions.setScope((SearchScope)new LocalSearchScope(elements));
            } else {
                parent = ((LocalSearchScope)options.getMatchOptions().getScope()).getScope()[0];
                firstElement = parent.getFirstChild();
                lastElement = parent.getLastChild();
            }
            matchOptions.setResultIsContextMatch(true);
            CollectingMatchResultSink sink = new CollectingMatchResultSink();
            matcher.testFindMatches(sink, matchOptions);
            SmartList resultPtrList = new SmartList();
            for (MatchResult result2 : sink.getMatches()) {
                resultPtrList.add(this.buildReplacement(result2));
            }
            int startOffset = firstElement.getTextRange().getStartOffset();
            int endOffset = filePattern ? 0 : parent.getTextLength() - lastElement.getTextRange().getEndOffset();
            PsiElement prevSibling = firstElement.getPrevSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                startOffset -= prevSibling.getTextLength() - 1;
            }
            if ((nextSibling = lastElement.getNextSibling()) instanceof PsiWhiteSpace) {
                endOffset -= nextSibling.getTextLength() - 1;
            }
            this.replaceAll((List<ReplacementInfo>)resultPtrList);
            String result3 = parent.getText();
            result3 = result3.substring(startOffset);
            String string = result3 = result3.substring(0, result3.length() - endOffset);
            return string;
        }
        catch (Exception e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        finally {
            options.getMatchOptions().setScope(null);
        }
    }

    public void replaceAll(List<ReplacementInfo> infos) {
        for (ReplacementInfo info : infos) {
            PsiElement element = info.getMatch(0);
            this.initContextAndHandler(element);
            if (this.replaceHandler == null) continue;
            this.replaceHandler.prepare(info);
        }
        ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithProgressInDispatchThread(SSRBundle.message("structural.replace.title", new Object[0]), this.project, null, "Stop", (Consumer<ProgressIndicator>)((Consumer)indicator -> {
            try {
                int size = infos.size();
                VirtualFile lastFile = null;
                for (int i = 0; i < size; ++i) {
                    indicator.checkCanceled();
                    indicator.setFraction((double)((float)(i + 1) / (float)size));
                    ReplacementInfo info = (ReplacementInfo)infos.get(i);
                    PsiElement element = info.getMatch(0);
                    assert (element != null);
                    VirtualFile vFile = element.getContainingFile().getVirtualFile();
                    if (vFile != null && !vFile.equals(lastFile)) {
                        indicator.setText2(vFile.getPresentableUrl());
                        lastFile = vFile;
                    }
                    ProgressManager.getInstance().executeNonCancelableSection(() -> {
                        PsiElement affectedElement = this.doReplace(info);
                        if (affectedElement != this.lastAffectedElement) {
                            if (this.lastAffectedElement != null) {
                                this.reformatAndPostProcess(this.lastAffectedElement);
                            }
                            this.lastAffectedElement = affectedElement;
                        }
                    });
                }
            }
            finally {
                ProgressManager.getInstance().executeNonCancelableSection(() -> this.reformatAndPostProcess(this.lastAffectedElement));
            }
        }));
    }

    public void replace(ReplacementInfo info) {
        this.initContextAndHandler(info.getMatch(0));
        if (this.replaceHandler != null) {
            this.replaceHandler.prepare(info);
        }
        this.reformatAndPostProcess(this.doReplace(info));
    }

    @Nullable
    private PsiElement doReplace(ReplacementInfo info) {
        PsiElement element = info.getMatch(0);
        if (element == null || !element.isWritable() || !element.isValid()) {
            return null;
        }
        PsiElement elementParent = element.getParent();
        CodeStyleManager.getInstance((Project)this.project).performActionWithFormatterDisabled(() -> {
            if (this.replaceHandler != null) {
                this.replaceHandler.replace(info, this.options);
            }
        });
        if (!elementParent.isValid() || !elementParent.isWritable()) {
            return null;
        }
        return elementParent;
    }

    private void reformatAndPostProcess(PsiElement elementParent) {
        if (elementParent == null) {
            return;
        }
        PsiFile containingFile = elementParent.getContainingFile();
        if (containingFile != null && this.options.isToReformatAccordingToStyle()) {
            VirtualFile file2 = containingFile.getVirtualFile();
            if (file2 != null) {
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(FileDocumentManager.getInstance().getDocument(file2));
            }
            int parentOffset = elementParent.getTextRange().getStartOffset();
            CodeStyleManager.getInstance((Project)this.project).reformatRange((PsiElement)containingFile, parentOffset, parentOffset + elementParent.getTextLength(), true);
        }
        if (this.replaceHandler != null) {
            this.replaceHandler.postProcess(elementParent, this.options);
        }
    }

    private void initContextAndHandler(PsiElement psiContext) {
        StructuralSearchProfile profile2;
        if (this.context == null) {
            this.context = new ReplacementContext(this.options, this.project);
        }
        if (this.replaceHandler == null && (profile2 = StructuralSearchUtil.getProfileByPsiElement(psiContext)) != null) {
            this.replaceHandler = profile2.getReplaceHandler(this.context);
        }
    }

    public static void handleComments(PsiElement el, PsiElement replacement, ReplacementInfo replacementInfo) {
        PsiElement firstChild;
        PsiElement lastChild = el.getLastChild();
        if (lastChild instanceof PsiComment && replacementInfo.getVariableName(lastChild) == null && !(replacement.getLastChild() instanceof PsiComment)) {
            PsiElement firstElementAfterStatementEnd = lastChild;
            for (PsiElement curElement = firstElementAfterStatementEnd.getPrevSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getPrevSibling()) {
                firstElementAfterStatementEnd = curElement;
            }
            replacement.addRangeAfter(firstElementAfterStatementEnd, lastChild, replacement.getLastChild());
        }
        if ((firstChild = el.getFirstChild()) instanceof PsiComment && !(firstChild instanceof PsiDocCommentBase) && replacementInfo.getVariableName(firstChild) == null) {
            PsiElement lastElementBeforeStatementStart = firstChild;
            for (PsiElement curElement = lastElementBeforeStatementStart.getNextSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getNextSibling()) {
                lastElementBeforeStatementStart = curElement;
            }
            replacement.addRangeBefore(firstChild, lastElementBeforeStatementStart, replacement.getFirstChild());
        }
    }

    public static void checkSupportedReplacementPattern(Project project2, ReplaceOptions options) throws UnsupportedPatternException {
        try {
            String search2 = options.getMatchOptions().getSearchPattern();
            String replacement = options.getReplacement();
            FileType fileType = options.getMatchOptions().getFileType();
            Template template = TemplateManager.getInstance(project2).createTemplate("", "", search2);
            Template template2 = TemplateManager.getInstance(project2).createTemplate("", "", replacement);
            int segmentCount = template2.getSegmentsCount();
            for (int i = 0; i < segmentCount; ++i) {
                String searchSegmentName;
                int j;
                String replacementSegmentName = template2.getSegmentName(i);
                int segmentCount2 = template.getSegmentsCount();
                for (j = 0; j < segmentCount2 && !replacementSegmentName.equals(searchSegmentName = template.getSegmentName(j)); ++j) {
                    if (!replacementSegmentName.startsWith(searchSegmentName) || replacementSegmentName.charAt(searchSegmentName.length()) != '_') continue;
                    try {
                        Integer.parseInt(replacementSegmentName.substring(searchSegmentName.length() + 1));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (j != segmentCount2) continue;
                ReplacementVariableDefinition definition = options.getVariableDefinition(replacementSegmentName);
                if (definition == null || definition.getScriptCodeConstraint().length() <= 2) {
                    throw new UnsupportedPatternException(SSRBundle.message("replacement.variable.is.not.defined.message", replacementSegmentName));
                }
                String message2 = ScriptSupport.checkValidScript(StringUtil.stripQuotesAroundValue((String)definition.getScriptCodeConstraint()));
                if (message2 == null) continue;
                throw new UnsupportedPatternException(SSRBundle.message("replacement.variable.is.not.valid", replacementSegmentName, message2));
            }
            StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(fileType);
            assert (profile2 != null);
            profile2.checkReplacementPattern(project2, options);
        }
        catch (IncorrectOperationException ex) {
            throw new UnsupportedPatternException(SSRBundle.message("incorrect.pattern.message", new Object[0]));
        }
    }

    public ReplacementInfo buildReplacement(MatchResult result2) {
        ReplacementInfoImpl replacementInfo = new ReplacementInfoImpl(result2, this.project);
        if (this.replacementBuilder == null) {
            this.replacementBuilder = new ReplacementBuilder(this.project, this.options);
        }
        replacementInfo.setReplacement(this.replacementBuilder.process(result2, replacementInfo, this.options.getMatchOptions().getFileType()));
        return replacementInfo;
    }
}

