/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.usageView.UsageInfo;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class ReplacementPreviewDialog
extends DialogWrapper {
    private final FileType myFileType;
    private Editor replacement;
    private final Project project;
    private RangeHighlighter hilighter;
    private Editor editor;

    public ReplacementPreviewDialog(Project project2, UsageInfo info, String replacementString) {
        super(project2, true);
        this.setTitle(SSRBundle.message("structural.replace.preview.dialog.title", new Object[0]));
        this.setOKButtonText(SSRBundle.message("replace.preview.oktext", new Object[0]));
        this.project = project2;
        PsiElement element = info.getElement();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        this.myFileType = virtualFile != null ? virtualFile.getFileType() : FileTypes.PLAIN_TEXT;
        this.init();
        Segment range = info.getSegment();
        this.hilight(virtualFile, range.getStartOffset(), range.getEndOffset());
        UIUtil.setContent(this.replacement, replacementString, 0, -1, project2);
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
        if (profile2 != null) {
            UIUtil.updateHighlighter(this.replacement, profile2);
        }
    }

    private void hilight(VirtualFile file2, int start, int end) {
        this.removeHilighter();
        this.editor = FileEditorManager.getInstance((Project)this.project).openTextEditor(new OpenFileDescriptor(this.project, file2), false);
        this.hilighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, 5900, EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES), HighlighterTargetArea.EXACT_RANGE);
    }

    private void removeHilighter() {
        if (this.hilighter != null && this.hilighter.isValid()) {
            this.hilighter.dispose();
            this.hilighter = null;
            this.editor = null;
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.strucuturalsearch.plugin.replace.ReplacementPreviewDialog";
    }

    protected JComponent createCenterPanel() {
        JPanel centerPanel = new JPanel(new BorderLayout());
        PsiCodeFragment file2 = null;
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (profile2 != null) {
            file2 = profile2.createCodeFragment(this.project, "", null);
        }
        if (file2 != null) {
            Document document = PsiDocumentManager.getInstance((Project)this.project).getDocument((PsiFile)file2);
            this.replacement = UIUtil.createEditor(document, this.project, true, null);
            DaemonCodeAnalyzer.getInstance((Project)this.project).setHighlightingEnabled((PsiFile)file2, false);
        } else {
            EditorFactory factory = EditorFactory.getInstance();
            Document document = factory.createDocument((CharSequence)"");
            this.replacement = factory.createEditor(document, this.project, this.myFileType, false);
        }
        centerPanel.add("North", new JLabel(SSRBundle.message("replacement.code", new Object[0])));
        centerPanel.add("Center", this.replacement.getComponent());
        centerPanel.setMaximumSize(new Dimension(640, 480));
        return centerPanel;
    }

    public void dispose() {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.replacement.getDocument());
        if (file2 != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.project).setHighlightingEnabled(file2, true);
        }
        EditorFactory.getInstance().releaseEditor(this.replacement);
        this.removeHilighter();
        super.dispose();
    }
}

