/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.testFramework.AbstractMockGlyphVector;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MockFontLayoutService
extends FontLayoutService {
    private final int myCharWidth;
    private final int myLineHeight;
    private final int myDescent;

    public MockFontLayoutService(int charWidth, int lineHeight, int descent) {
        this.myCharWidth = charWidth;
        this.myLineHeight = lineHeight;
        this.myDescent = descent;
    }

    @Override
    @NotNull
    public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, @NotNull char[] chars, int start, int end, boolean isRtl) {
        if (font == null) {
            MockFontLayoutService.$$$reportNull$$$0(0);
        }
        if (fontRenderContext == null) {
            MockFontLayoutService.$$$reportNull$$$0(1);
        }
        if (chars == null) {
            MockFontLayoutService.$$$reportNull$$$0(2);
        }
        MockGlyphVector mockGlyphVector = new MockGlyphVector(Arrays.copyOfRange(chars, start, end), isRtl);
        if (mockGlyphVector == null) {
            MockFontLayoutService.$$$reportNull$$$0(3);
        }
        return mockGlyphVector;
    }

    @Override
    public int charWidth(@NotNull FontMetrics fontMetrics, char c) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(4);
        }
        return this.myCharWidth;
    }

    @Override
    public int charWidth(@NotNull FontMetrics fontMetrics, int codePoint) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(5);
        }
        return this.myCharWidth;
    }

    @Override
    public float charWidth2D(@NotNull FontMetrics fontMetrics, int codePoint) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(6);
        }
        return this.myCharWidth;
    }

    @Override
    public int getHeight(@NotNull FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(7);
        }
        return this.myLineHeight;
    }

    @Override
    public int getDescent(@NotNull FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(8);
        }
        return this.myDescent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontRenderContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/MockFontLayoutService";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/MockFontLayoutService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutGlyphVector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "layoutGlyphVector";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "charWidth";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "charWidth2D";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHeight";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDescent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MockGlyphVector
    extends AbstractMockGlyphVector {
        private final char[] myChars;
        private final boolean myIsRtl;

        private MockGlyphVector(char[] chars, boolean isRtl) {
            this.myChars = chars;
            this.myIsRtl = isRtl;
        }

        @Override
        public int getNumGlyphs() {
            return this.myChars.length;
        }

        @Override
        public int getGlyphCharIndex(int glyphIndex) {
            return this.myIsRtl ? this.myChars.length - 1 - glyphIndex : glyphIndex;
        }

        @Override
        public Point2D getGlyphPosition(int glyphIndex) {
            return new Point(glyphIndex * MockFontLayoutService.this.myCharWidth, 0);
        }

        @Override
        public Shape getGlyphLogicalBounds(int glyphIndex) {
            return new Rectangle(glyphIndex * MockFontLayoutService.this.myCharWidth, -MockFontLayoutService.this.myDescent, MockFontLayoutService.this.myCharWidth, MockFontLayoutService.this.myLineHeight);
        }

        @Override
        public int getGlyphCode(int glyphIndex) {
            return this.myChars[glyphIndex];
        }
    }
}

