/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.text.AsyncHighlighterUpdater;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static IdeaTestApplication ourApplication;
    private static boolean ourReportedLeakedProjects;
    protected ProjectManagerEx myProjectManager;
    protected Project myProject;
    protected Module myModule;
    protected static final Collection<File> myFilesToDelete;
    protected boolean myAssertionsInTestDetected;
    public static Thread ourTestThread;
    private static TestCase ourTestCase;
    private static final long DEFAULT_TEST_TIME = 300L;
    public static long ourTestTime;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private static boolean ourPlatformPrefixInitialized;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private SdkLeakTracker myOldSdks;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    private static final String[] PREFIX_CANDIDATES;

    public static void synchronizeTempDirVfs(@NotNull VirtualFile tempDir) {
        if (tempDir == null) {
            PlatformTestCase.$$$reportNull$$$0(0);
        }
        tempDir.getChildren();
        tempDir.refresh(false, true);
    }

    protected void initApplication() throws Exception {
        boolean firstTime = ourApplication == null;
        ourApplication = IdeaTestApplication.getInstance(null);
        ourApplication.setDataProvider(this);
        if (firstTime) {
            PlatformTestCase.cleanPersistedVFSContent();
        }
        this.myOldSdks = new SdkLeakTracker();
    }

    public static void autodetectPlatformPrefix() {
        PlatformTestCase.doAutodetectPlatformPrefix();
    }

    public static void doAutodetectPlatformPrefix() {
        if (ourPlatformPrefixInitialized) {
            return;
        }
        for (String candidate : PREFIX_CANDIDATES) {
            String markerPath = candidate != null ? "META-INF/" + candidate + "Plugin.xml" : "idea/ApplicationInfo.xml";
            URL resource = PlatformTestCase.class.getClassLoader().getResource(markerPath);
            if (resource == null) continue;
            if (candidate == null) break;
            PlatformTestCase.setPlatformPrefix(candidate);
            break;
        }
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    @Override
    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            CodeStyleSettings codeStyleSettings = new CodeStyleSettings();
            if (codeStyleSettings == null) {
                PlatformTestCase.$$$reportNull$$$0(1);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)this.getProject());
        if (codeStyleSettings == null) {
            PlatformTestCase.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File tempDir = new File(FileUtilRt.getTempDirectory());
        myFilesToDelete.add(tempDir);
        if (ourTestCase != null) {
            String message2 = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            PlatformTestCase.fail((String)message2);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.debug(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        if (this.myOldSdks == null) {
            this.myOldSdks = new SdkLeakTracker();
        }
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        this.setUpProject();
        this.storeSettings();
        ourTestCase = this;
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
            CodeStyleSettingsManager.getInstance((Project)this.myProject).setTemporarySettings(new CodeStyleSettings());
            InjectedLanguageManagerImpl.pushInjectors(this.getProject());
        }
        DocumentCommitThread.getInstance().clearQueue();
        UIUtil.dispatchAllInvocationEvents();
        this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        PlatformTestCase.assertNotNull((String)"Cannot instantiate ProjectManager component", (Object)((Object)this.myProjectManager));
        File projectFile = this.getIprFile();
        this.myProject = this.doCreateProject(projectFile);
        this.myProjectManager.openTestProject(this.myProject);
        LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
        this.setUpModule();
        this.setUpJdk();
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        this.runStartupActivities();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected Project doCreateProject(@NotNull File projectFile) throws Exception {
        if (projectFile == null) {
            PlatformTestCase.$$$reportNull$$$0(3);
        }
        return PlatformTestCase.createProject(projectFile, ((Object)((Object)this)).getClass().getName() + "." + this.getName());
    }

    @NotNull
    public static Project createProject(File projectFile, @NotNull String creationPlace) {
        if (creationPlace == null) {
            PlatformTestCase.$$$reportNull$$$0(4);
        }
        Project project2 = PlatformTestCase.createProject(projectFile.getPath(), creationPlace);
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(5);
        }
        return project2;
    }

    @NotNull
    public static Project createProject(@NotNull String path, @NotNull String creationPlace) {
        Project project2;
        if (path == null) {
            PlatformTestCase.$$$reportNull$$$0(6);
        }
        if (creationPlace == null) {
            PlatformTestCase.$$$reportNull$$$0(7);
        }
        String fileName = PathUtilRt.getFileName((String)path);
        try {
            String projectName = FileUtilRt.getNameWithoutExtension((String)fileName);
            Project project3 = ProjectManagerEx.getInstanceEx().newProject(projectName, path, false, false);
            assert (project3 != null);
            project3.putUserData(CREATION_PLACE, (Object)creationPlace);
            project2 = project3;
        }
        catch (TooManyProjectLeakedException e) {
            if (ourReportedLeakedProjects) {
                PlatformTestCase.fail((String)"Too many projects leaked, again.");
                if (null == null) {
                    PlatformTestCase.$$$reportNull$$$0(9);
                }
                return null;
            }
            ourReportedLeakedProjects = true;
            TIntHashSet hashCodes = new TIntHashSet();
            for (Project project4 : e.getLeakedProjects()) {
                hashCodes.add(System.identityHashCode(project4));
            }
            String dumpPath = PathManager.getHomePath() + "/leakedProjects.hprof.zip";
            System.out.println("##teamcity[publishArtifacts 'leakedProjects.hprof.zip']");
            try {
                FileUtil.delete((File)new File(dumpPath));
                MemoryDumpHelper.captureMemoryDumpZipped((String)dumpPath);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            StringBuilder leakers = new StringBuilder();
            leakers.append("Too many projects leaked: \n");
            LeakHunter.processLeaks(LeakHunter.allRoots(), ProjectImpl.class, p -> hashCodes.contains(System.identityHashCode(p)), (leaked, backLink) -> {
                int hashCode = System.identityHashCode(leaked);
                leakers.append("Leaked project found:" + leaked + "; hash: " + hashCode + "; place: " + PlatformTestCase.getCreationPlace(leaked) + "\n");
                leakers.append(backLink + "\n");
                leakers.append(";-----\n");
                hashCodes.remove(hashCode);
                return !hashCodes.isEmpty();
            });
            PlatformTestCase.fail((String)(leakers + "\nPlease see '" + dumpPath + "' for a memory dump"));
            if (null == null) {
                PlatformTestCase.$$$reportNull$$$0(10);
            }
            return null;
        }
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(8);
        }
        return project2;
    }

    @NotNull
    public static String getCreationPlace(@NotNull Project project2) {
        String base;
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(11);
        }
        String place = (String)project2.getUserData(CREATION_PLACE);
        try {
            base = project2.isDisposed() ? "" : project2.getBaseDir();
        }
        catch (Exception e) {
            base = " (" + e + " while getting base dir)";
        }
        String string = project2 + (place != null ? place : "") + base;
        if (string == null) {
            PlatformTestCase.$$$reportNull$$$0(12);
        }
        return string;
    }

    protected void runStartupActivities() {
        StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)this.myProject);
        startupManager.runStartupActivities();
        startupManager.startCacheUpdate();
        startupManager.runPostStartupActivities();
    }

    protected File getIprFile() throws IOException {
        File tempFile = FileUtil.createTempFile((String)this.getName(), (String)".ipr");
        myFilesToDelete.add(tempFile);
        return tempFile;
    }

    protected void setUpModule() {
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                PlatformTestCase.this.myModule = PlatformTestCase.this.createMainModule();
            }
        }.execute().throwException();
    }

    @NotNull
    protected Module createMainModule() throws IOException {
        Module module2 = this.createModule(this.myProject.getName());
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(13);
        }
        return module2;
    }

    @NotNull
    protected Module createModule(@NonNls String moduleName) {
        Module module2 = this.doCreateRealModule(moduleName);
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(14);
        }
        return module2;
    }

    @NotNull
    protected Module doCreateRealModule(String moduleName) {
        Module module2 = PlatformTestCase.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(15);
        }
        return module2;
    }

    @NotNull
    protected static Module doCreateRealModuleIn(String moduleName, Project project2, ModuleType moduleType) {
        VirtualFile baseDir = project2.getBaseDir();
        PlatformTestCase.assertNotNull((Object)baseDir);
        Module module2 = PlatformTestCase.createModuleAt(moduleName, project2, moduleType, baseDir.getPath());
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(16);
        }
        return module2;
    }

    @NotNull
    protected static Module createModuleAt(String moduleName, final Project project2, final ModuleType moduleType, String path) {
        final File moduleFile = new File(FileUtil.toSystemDependentName((String)path), moduleName + ".iml");
        FileUtil.createIfDoesntExist((File)moduleFile);
        myFilesToDelete.add(moduleFile);
        Module module2 = (Module)new WriteAction<Module>(){

            protected void run(@NotNull Result<Module> result2) throws Throwable {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleFile);
                TestCase.assertNotNull((Object)virtualFile);
                Module module2 = ModuleManager.getInstance((Project)project2).newModule(virtualFile.getPath(), moduleType.getId());
                module2.getModuleFile();
                result2.setResult((Object)module2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$2", "run"));
            }
        }.execute().getResultObject();
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(17);
        }
        return module2;
    }

    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    public static void cleanupApplicationCaches(Project project2) {
        UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
        if (globalInstance != null) {
            globalInstance.dropHistoryInTests();
        }
        if (project2 != null && !project2.isDisposed()) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
            ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        assert (projectManager != null) : "The ProjectManager is not initialized yet";
        ProjectManagerImpl projectManagerImpl = (ProjectManagerImpl)projectManager;
        if (projectManagerImpl.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiManagerImpl)PsiManager.getInstance((Project)defaultProject)).cleanupForNextTest();
        }
        AsyncHighlighterUpdater.completeAsyncTasks();
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).cleanupForNextTest();
        LocalFileSystemImpl localFileSystem = (LocalFileSystemImpl)LocalFileSystem.getInstance();
        if (localFileSystem != null) {
            localFileSystem.cleanupForNextTest();
        }
    }

    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            return ourEternallyLivingFilesCache;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file2 : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                PlatformTestCase.registerSurvivor(survivors, file2);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        return survivors;
    }

    public static void addSurvivingFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            PlatformTestCase.$$$reportNull$$$0(18);
        }
        for (VirtualFile each : files) {
            PlatformTestCase.registerSurvivor(PlatformTestCase.eternallyLivingFiles(), each);
        }
    }

    private static void registerSurvivor(Set<VirtualFile> survivors, VirtualFile file2) {
        PlatformTestCase.addSubTree(file2, survivors);
        while (file2 != null && survivors.add(file2)) {
            file2 = file2.getParent();
        }
    }

    private static void addSubTree(VirtualFile root, Set<VirtualFile> to) {
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child instanceof VirtualDirectoryImpl)) continue;
                to.add(child);
                PlatformTestCase.addSubTree(child, to);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.myProject;
        new RunAll(new ThrowableRunnable[0]).append(this::disposeRootDisposable).append(() -> {
            if (project2 != null) {
                LightPlatformTestCase.doTearDown(project2, ourApplication);
            }
        }).append(this::disposeProject).append(() -> UIUtil.dispatchAllInvocationEvents()).append(this::checkForSettingsDamage).append(() -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project2);
            }
        }).append(() -> {
            ((JarFileSystemImpl)JarFileSystem.getInstance()).cleanupForNextTest();
            for (File fileToDelete : myFilesToDelete) {
                this.delete(fileToDelete);
            }
            LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
        }).append(() -> {
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }).append(() -> super.tearDown()).append(() -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }).append(() -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }).append(LightPlatformTestCase::checkEditorsReleased).append(() -> this.myOldSdks.checkForJdkTableLeaks()).append(() -> this.myVirtualFilePointerTracker.assertPointersAreDisposed()).append(() -> {
            this.myProjectManager = null;
            this.myProject = null;
            this.myModule = null;
            myFilesToDelete.clear();
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
        }).run();
    }

    private void disposeProject() {
        if (this.myProject != null) {
            PlatformTestCase.closeAndDisposeProjectAndCheckThatNoOpenProjects(this.myProject);
            this.myProject = null;
        }
    }

    public static void closeAndDisposeProjectAndCheckThatNoOpenProjects(@NotNull Project projectToClose) {
        if (projectToClose == null) {
            PlatformTestCase.$$$reportNull$$$0(19);
        }
        RunAll runAll = new RunAll(new ThrowableRunnable[0]);
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        if (projectManager instanceof ProjectManagerImpl) {
            for (Project project2 : projectManager.closeTestProject(projectToClose)) {
                runAll = runAll.append(() -> {
                    throw new IllegalStateException("Test project is not disposed: " + project2 + ";\n created in: " + PlatformTestCase.getCreationPlace(project2));
                }).append(() -> ((ProjectManagerImpl)projectManager).forceCloseProject(project2, true));
            }
        }
        runAll.append(() -> {
            if (projectToClose == null) {
                PlatformTestCase.$$$reportNull$$$0(59);
            }
            WriteAction.run(() -> {
                if (projectToClose == null) {
                    PlatformTestCase.$$$reportNull$$$0(60);
                }
                Disposer.dispose((Disposable)projectToClose);
            });
        }).run();
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    protected final <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register((Disposable)this.myProject, disposable);
        return disposable;
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            PlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == PlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private String getFullName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    private void delete(File file2) {
        boolean b = FileUtil.delete((File)file2);
        if (!b && file2.exists() && !this.myAssertionsInTestDetected) {
            PlatformTestCase.fail((String)("Can't delete " + file2.getAbsolutePath() + " in " + this.getFullName()));
        }
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        try {
            this.runBareImpl();
        }
        finally {
            try {
                EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                    PlatformTestCase.cleanupApplicationCaches(this.getProject());
                    this.resetAllFields();
                }));
            }
            catch (Throwable throwable) {}
        }
    }

    private void runBareImpl() throws Throwable {
        ThrowableRunnable runnable2 = () -> {
            ourTestThread = Thread.currentThread();
            ourTestTime = 300L;
            try {
                try {
                    this.myAssertionsInTestDetected = true;
                    this.setUp();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable e) {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw e;
                }
                Throwable exception = null;
                try {
                    this.myAssertionsInTestDetected = true;
                    this.runTest();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable e) {
                    exception = e;
                }
                finally {
                    block20: {
                        try {
                            this.tearDown();
                        }
                        catch (Throwable e) {
                            if (exception != null) break block20;
                            exception = e;
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
            finally {
                ourTestThread = null;
            }
        };
        this.runBareRunnable((ThrowableRunnable<Throwable>)runnable2);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        PlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(ThrowableRunnable<Throwable> runnable2) throws Throwable {
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait(runnable2);
        } else {
            runnable2.run();
        }
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void invokeTestRunnable(@NotNull Runnable runnable2) throws Exception {
        if (runnable2 == null) {
            PlatformTestCase.$$$reportNull$$$0(20);
        }
        Exception[] e = new Exception[1];
        Runnable runnable1 = () -> {
            if (runnable2 == null) {
                PlatformTestCase.$$$reportNull$$$0(58);
            }
            try {
                if (ApplicationManager.getApplication().isDispatchThread() && this.isRunInWriteAction()) {
                    ApplicationManager.getApplication().runWriteAction(runnable2);
                } else {
                    runnable2.run();
                }
            }
            catch (Exception e1) {
                e[0] = e1;
            }
        };
        if (this.annotatedWith(WrapInCommand.class)) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    public Object getData(String dataId) {
        return this.myProject == null ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    @NotNull
    public static File createTempDir(@NonNls String prefix) throws IOException {
        File file2 = PlatformTestCase.createTempDir(prefix, true);
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(21);
        }
        return file2;
    }

    @NotNull
    public static File createTempDir(@NonNls String prefix, boolean refresh) throws IOException {
        File tempDirectory = FileUtilRt.createTempDirectory((String)("idea_test_" + prefix), null, (boolean)false);
        myFilesToDelete.add(tempDirectory);
        if (refresh) {
            PlatformTestCase.getVirtualFile(tempDirectory);
        }
        File file2 = tempDirectory;
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(22);
        }
        return file2;
    }

    protected static VirtualFile getVirtualFile(@NotNull File file2) {
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(23);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }

    @NotNull
    protected File createTempDirectory() throws IOException {
        File file2 = PlatformTestCase.createTempDir("");
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(24);
        }
        return file2;
    }

    @NotNull
    protected File createTempDirectory(boolean refresh) throws IOException {
        File file2 = PlatformTestCase.createTempDir("", refresh);
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(25);
        }
        return file2;
    }

    @NotNull
    protected File createTempFile(@NotNull String name2, @Nullable String text2) throws IOException {
        File directory;
        File file2;
        if (name2 == null) {
            PlatformTestCase.$$$reportNull$$$0(26);
        }
        if (!(file2 = new File(directory = this.createTempDirectory(), name2)).createNewFile()) {
            throw new IOException("Can't create " + file2);
        }
        if (text2 != null) {
            FileUtil.writeToFile((File)file2, (String)text2);
        }
        File file3 = file2;
        if (file3 == null) {
            PlatformTestCase.$$$reportNull$$$0(27);
        }
        return file3;
    }

    public static void setContentOnDisk(@NotNull File file2, @Nullable byte[] bom, @NotNull String content, @NotNull Charset charset) throws IOException {
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(28);
        }
        if (content == null) {
            PlatformTestCase.$$$reportNull$$$0(29);
        }
        if (charset == null) {
            PlatformTestCase.$$$reportNull$$$0(30);
        }
        FileOutputStream stream = new FileOutputStream(file2);
        if (bom != null) {
            stream.write(bom);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write(content);
        }
    }

    @NotNull
    public static VirtualFile createTempFile(@NonNls @NotNull String ext, @Nullable byte[] bom, @NonNls @NotNull String content, @NotNull Charset charset) throws IOException {
        if (ext == null) {
            PlatformTestCase.$$$reportNull$$$0(31);
        }
        if (content == null) {
            PlatformTestCase.$$$reportNull$$$0(32);
        }
        if (charset == null) {
            PlatformTestCase.$$$reportNull$$$0(33);
        }
        File temp = FileUtil.createTempFile((String)"copy", (String)("." + ext));
        PlatformTestCase.setContentOnDisk(temp, bom, content, charset);
        myFilesToDelete.add(temp);
        VirtualFile file2 = PlatformTestCase.getVirtualFile(temp);
        assert (file2 != null) : temp;
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(34);
        }
        return virtualFile;
    }

    @Nullable
    protected PsiFile getPsiFile(Document document) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    public static void initPlatformLangPrefix() {
    }

    public static void initPlatformPrefix(String classToTest, String prefix) {
        if (!ourPlatformPrefixInitialized) {
            ourPlatformPrefixInitialized = true;
            boolean isUltimate = true;
            try {
                PlatformTestCase.class.getClassLoader().loadClass(classToTest);
            }
            catch (ClassNotFoundException e) {
                isUltimate = false;
            }
            if (!isUltimate) {
                PlatformTestCase.setPlatformPrefix(prefix);
            }
        }
    }

    private static void setPlatformPrefix(String prefix) {
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    @NotNull
    protected static VirtualFile createChildData(final @NotNull VirtualFile dir, final @NotNull @NonNls String name2) {
        if (dir == null) {
            PlatformTestCase.$$$reportNull$$$0(35);
        }
        if (name2 == null) {
            PlatformTestCase.$$$reportNull$$$0(36);
        }
        VirtualFile virtualFile = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result2) throws Throwable {
                if (result2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                result2.setResult((Object)dir.createChildData(null, name2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$3", "run"));
            }
        }.execute().throwException().getResultObject();
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(37);
        }
        return virtualFile;
    }

    @NotNull
    protected static VirtualFile createChildDirectory(final @NotNull VirtualFile dir, final @NotNull @NonNls String name2) {
        if (dir == null) {
            PlatformTestCase.$$$reportNull$$$0(38);
        }
        if (name2 == null) {
            PlatformTestCase.$$$reportNull$$$0(39);
        }
        VirtualFile virtualFile = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result2) throws Throwable {
                if (result2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                result2.setResult((Object)dir.createChildDirectory(null, name2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$4", "run"));
            }
        }.execute().throwException().getResultObject();
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(40);
        }
        return virtualFile;
    }

    protected static void rename(final @NotNull VirtualFile vFile1, final @NotNull String newName) {
        if (vFile1 == null) {
            PlatformTestCase.$$$reportNull$$$0(41);
        }
        if (newName == null) {
            PlatformTestCase.$$$reportNull$$$0(42);
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                vFile1.rename((Object)this, newName);
            }
        }.execute().throwException();
    }

    protected static void delete(@NotNull VirtualFile vFile1) {
        if (vFile1 == null) {
            PlatformTestCase.$$$reportNull$$$0(43);
        }
        VfsTestUtil.deleteFile(vFile1);
    }

    public static void move(final @NotNull VirtualFile vFile1, final @NotNull VirtualFile newFile) {
        if (vFile1 == null) {
            PlatformTestCase.$$$reportNull$$$0(44);
        }
        if (newFile == null) {
            PlatformTestCase.$$$reportNull$$$0(45);
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                vFile1.move((Object)this, newFile);
            }
        }.execute().throwException();
    }

    @NotNull
    protected static VirtualFile copy(final @NotNull VirtualFile file2, final @NotNull VirtualFile newParent, final @NotNull String copyName) {
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(46);
        }
        if (newParent == null) {
            PlatformTestCase.$$$reportNull$$$0(47);
        }
        if (copyName == null) {
            PlatformTestCase.$$$reportNull$$$0(48);
        }
        final VirtualFile[] copy = new VirtualFile[1];
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                copy[0] = file2.copy((Object)this, newParent, copyName);
            }
        }.execute().throwException();
        VirtualFile virtualFile = copy[0];
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(49);
        }
        return virtualFile;
    }

    public static void copyDirContentsTo(final @NotNull VirtualFile vTestRoot, final @NotNull VirtualFile toDir) {
        if (vTestRoot == null) {
            PlatformTestCase.$$$reportNull$$$0(50);
        }
        if (toDir == null) {
            PlatformTestCase.$$$reportNull$$$0(51);
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                for (VirtualFile file2 : vTestRoot.getChildren()) {
                    VfsUtil.copy((Object)((Object)this), (VirtualFile)file2, (VirtualFile)toDir);
                }
            }
        }.execute().throwException();
    }

    public static void setFileText(final @NotNull VirtualFile file2, final @NotNull String text2) {
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(52);
        }
        if (text2 == null) {
            PlatformTestCase.$$$reportNull$$$0(53);
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    9.$$$reportNull$$$0(0);
                }
                VfsUtil.saveText((VirtualFile)file2, (String)text2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$9", "run"));
            }
        }.execute().throwException();
    }

    public static void setBinaryContent(final @NotNull VirtualFile file2, final @NotNull byte[] content) {
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(54);
        }
        if (content == null) {
            PlatformTestCase.$$$reportNull$$$0(55);
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    10.$$$reportNull$$$0(0);
                }
                file2.setBinaryContent(content);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$10", "run"));
            }
        }.execute().throwException();
    }

    /*
     * WARNING - void declaration
     */
    public static void setBinaryContent(final @NotNull VirtualFile file2, final @NotNull byte[] content, final long newModificationStamp, final long newTimeStamp, Object object) {
        void requestor;
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(56);
        }
        if (content == null) {
            PlatformTestCase.$$$reportNull$$$0(57);
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    11.$$$reportNull$$$0(0);
                }
                file2.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$11", "run"));
            }
        }.execute().throwException();
    }

    static {
        myFilesToDelete = new THashSet();
        ourTestTime = 300L;
        PREFIX_CANDIDATES = new String[]{"Rider", null, "AppCode", "CLion", "CidrCommon", "DataGrip", "Python", "PyCharmCore", "Ruby", "UltimateLangXml", "Idea", "PlatformLangXml"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 34: 
            case 37: 
            case 40: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 34: 
            case 37: 
            case 40: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDir";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 34: 
            case 37: 
            case 40: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformTestCase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creationPlace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectToClose";
                break;
            }
            case 20: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 23: 
            case 28: 
            case 46: 
            case 52: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: 
            case 32: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 41: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile1";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vTestRoot";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformTestCase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCodeStyleSettings";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreationPlace";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModule";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModuleIn";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleAt";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDir";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 27: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeTempDirVfs";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 34: 
            case 37: 
            case 40: 
            case 49: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCreateProject";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCreationPlace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addSurvivingFiles";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDisposeProjectAndCheckThatNoOpenProjects";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invokeTestRunnable";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 26: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setContentOnDisk";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "copyDirContentsTo";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setFileText";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeTestRunnable$19";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$closeAndDisposeProjectAndCheckThatNoOpenProjects$16";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$15";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 34: 
            case 37: 
            case 40: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

