/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class TeamCityLogger {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.TeamCityLogger");
    private static final boolean isUnderTC = System.getProperty("bootstrap.testcases") != null;

    private TeamCityLogger() {
    }

    private static File reportFile() {
        return new File(PathManager.getHomePath() + "/reports/report.txt");
    }

    public static void info(String message2) {
        if (isUnderTC) {
            TeamCityLogger.tcLog(message2, null);
        } else {
            LOG.info(message2);
        }
    }

    public static void warning(String message2) {
        TeamCityLogger.warning(message2, new Throwable());
    }

    public static void warning(String message2, @Nullable Throwable throwable) {
        if (isUnderTC) {
            TeamCityLogger.tcLog(message2, "WARNING");
        } else {
            LOG.warn(message2, throwable);
        }
    }

    public static void error(String message2) {
        TeamCityLogger.error(message2, new Throwable());
    }

    public static void error(String message2, @Nullable Throwable throwable) {
        if (isUnderTC) {
            TeamCityLogger.tcLog(message2, "ERROR");
        } else {
            LOG.error(message2, throwable);
        }
    }

    private static void tcLog(String message2, String level) {
        try {
            if (level != null) {
                message2 = level + ": " + message2;
            }
            FileUtil.appendToFile((File)TeamCityLogger.reportFile(), (String)(message2 + "\n"));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }
}

