/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestLogger
extends Log4jBasedLogger {
    TestLogger(@NotNull Logger logger) {
        if (logger == null) {
            TestLogger.$$$reportNull$$$0(0);
        }
        super(logger);
    }

    public void warn(String message2, @Nullable Throwable t) {
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processWarn(message2, t, this.myLogger);
    }

    public void error(String message2, @Nullable Throwable t, String ... details) {
        if (details == null) {
            TestLogger.$$$reportNull$$$0(1);
        }
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processError(message2, t, details, this.myLogger);
    }

    public void debug(@NonNls String message2) {
        if (this.isDebugEnabled()) {
            super.debug(message2);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, message2, null);
        }
    }

    public void debug(@Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(t);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, null, t);
        }
    }

    public void debug(@NonNls String message2, @Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(message2, t);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, message2, t);
        }
    }

    public void info(@NonNls String message2) {
        super.info(message2);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message2, null);
    }

    public void info(@NonNls String message2, @Nullable Throwable t) {
        super.info(message2, t);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message2, t);
    }

    public boolean isDebugEnabled() {
        if (ApplicationInfoImpl.isInStressTest()) {
            return super.isDebugEnabled();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

