/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.WaitFor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyUtil;
import org.junit.Assert;

public class ThreadTracker {
    private static final Logger LOG = Logger.getInstance(ThreadTracker.class);
    private final Collection<Thread> before = ThreadTracker.getThreads();
    private final boolean myDefaultProjectInitialized = ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized();
    private static final Method getThreads = ReflectionUtil.getDeclaredMethod(Thread.class, (String)"getThreads", (Class[])new Class[0]);
    private static final Set<String> wellKnownOffenders = new THashSet();

    @NotNull
    public static Collection<Thread> getThreads() {
        Object[] threads;
        try {
            threads = (Thread[])getThreads.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList arrayList = ContainerUtilRt.newArrayList((Object[])threads);
        if (arrayList == null) {
            ThreadTracker.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public static void longRunningThreadCreated(@NotNull Disposable parentDisposable, String ... threadNamePrefixes) {
        if (parentDisposable == null) {
            ThreadTracker.$$$reportNull$$$0(1);
        }
        if (threadNamePrefixes == null) {
            ThreadTracker.$$$reportNull$$$0(2);
        }
        wellKnownOffenders.addAll(Arrays.asList(threadNamePrefixes));
        Disposer.register((Disposable)parentDisposable, () -> {
            if (threadNamePrefixes == null) {
                ThreadTracker.$$$reportNull$$$0(12);
            }
            wellKnownOffenders.removeAll(Arrays.asList(threadNamePrefixes));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLeak() throws AssertionError {
        NettyUtil.awaitQuiescenceOfGlobalEventExecutor(100L, TimeUnit.SECONDS);
        ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
        try {
            if (this.myDefaultProjectInitialized != ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized()) {
                return;
            }
            THashSet after2 = new THashSet(ThreadTracker.getThreads());
            after2.removeAll(this.before);
            for (final Thread thread : after2) {
                StackTraceElement[] stackTrace;
                ThreadGroup group;
                if (thread == Thread.currentThread() || (group = thread.getThreadGroup()) != null && "system".equals(group.getName()) || ThreadTracker.isWellKnownOffender(thread) || !thread.isAlive()) continue;
                if (thread.getStackTrace().length == 0) {
                    thread.interrupt();
                    if (new WaitFor(10000){

                        protected boolean condition() {
                            return !thread.isAlive();
                        }
                    }.isConditionRealized()) continue;
                }
                if ((stackTrace = thread.getStackTrace()).length == 0 || ThreadTracker.isIdleApplicationPoolThread(thread, stackTrace) || ThreadTracker.isIdleCommonPoolThread(thread, stackTrace)) continue;
                String trace = "Thread leaked: " + thread + "; " + (Object)((Object)thread.getState()) + " (" + thread.isAlive() + ")\n--- its stacktrace:\n";
                for (StackTraceElement stackTraceElement : stackTrace) {
                    trace = trace + " at " + stackTraceElement + "\n";
                }
                trace = trace + "---\n";
                Assert.fail((String)trace);
            }
        }
        finally {
            this.before.clear();
        }
    }

    private static boolean isWellKnownOffender(@NotNull Thread thread) {
        if (thread == null) {
            ThreadTracker.$$$reportNull$$$0(3);
        }
        String name2 = thread.getName();
        return ContainerUtil.exists(wellKnownOffenders, name2::contains);
    }

    private static boolean isIdleApplicationPoolThread(@NotNull Thread thread, @NotNull StackTraceElement[] stackTrace) {
        if (thread == null) {
            ThreadTracker.$$$reportNull$$$0(4);
        }
        if (stackTrace == null) {
            ThreadTracker.$$$reportNull$$$0(5);
        }
        if (!ThreadTracker.isWellKnownOffender(thread)) {
            return false;
        }
        boolean insideTPEGetTask = Arrays.stream(stackTrace).anyMatch(element -> element.getMethodName().equals("getTask") && element.getClassName().equals("java.util.concurrent.ThreadPoolExecutor"));
        return insideTPEGetTask;
    }

    private static boolean isIdleCommonPoolThread(@NotNull Thread thread, @NotNull StackTraceElement[] stackTrace) {
        if (thread == null) {
            ThreadTracker.$$$reportNull$$$0(6);
        }
        if (stackTrace == null) {
            ThreadTracker.$$$reportNull$$$0(7);
        }
        if (!ForkJoinWorkerThread.class.isAssignableFrom(thread.getClass())) {
            return false;
        }
        boolean insideAwaitWork = Arrays.stream(stackTrace).anyMatch(element -> element.getMethodName().equals("awaitWork") && element.getClassName().equals("java.util.concurrent.ForkJoinPool"));
        return insideAwaitWork;
    }

    public static void awaitJDIThreadsTermination(int timeout, @NotNull TimeUnit unit) {
        if (unit == null) {
            ThreadTracker.$$$reportNull$$$0(8);
        }
        ThreadTracker.awaitThreadTerminationWithParentParentGroup("JDI main", timeout, unit);
    }

    private static void awaitThreadTerminationWithParentParentGroup(@NotNull String grandThreadGroup, int timeout, @NotNull TimeUnit unit) {
        Thread jdiThread;
        if (grandThreadGroup == null) {
            ThreadTracker.$$$reportNull$$$0(9);
        }
        if (unit == null) {
            ThreadTracker.$$$reportNull$$$0(10);
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + unit.toMillis(timeout) && (jdiThread = (Thread)ContainerUtil.find(ThreadTracker.getThreads(), thread -> {
            ThreadGroup group;
            if (grandThreadGroup == null) {
                ThreadTracker.$$$reportNull$$$0(11);
            }
            return (group = thread.getThreadGroup()) != null && group.getParent() != null && grandThreadGroup.equals(group.getParent().getName());
        })) != null) {
            try {
                long timeLeft = start + unit.toMillis(timeout) - System.currentTimeMillis();
                LOG.debug("Waiting for the " + jdiThread + " for " + timeLeft + "ms");
                jdiThread.join(timeLeft);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        wellKnownOffenders.add("AWT-EventQueue-");
        wellKnownOffenders.add("AWT-Shutdown");
        wellKnownOffenders.add("AWT-Windows");
        wellKnownOffenders.add("CompilerThread0");
        wellKnownOffenders.add("External compiler");
        wellKnownOffenders.add("Finalizer");
        wellKnownOffenders.add("IDEA Test Case Thread");
        wellKnownOffenders.add("Image Fetcher ");
        wellKnownOffenders.add("Java2D Disposer");
        wellKnownOffenders.add("JobScheduler FJ pool ");
        wellKnownOffenders.add("JPS thread pool");
        wellKnownOffenders.add("Keep-Alive-Timer");
        wellKnownOffenders.add("main");
        wellKnownOffenders.add("Monitor Ctrl-Break");
        wellKnownOffenders.add("Netty ");
        wellKnownOffenders.add("Reference Handler");
        wellKnownOffenders.add("RMI TCP Connection");
        wellKnownOffenders.add("Signal Dispatcher");
        wellKnownOffenders.add("timer-int");
        wellKnownOffenders.add("timer-sys");
        wellKnownOffenders.add("TimerQueue");
        wellKnownOffenders.add("UserActivityMonitor thread");
        wellKnownOffenders.add("VM Periodic Task Thread");
        wellKnownOffenders.add("VM Thread");
        wellKnownOffenders.add("YJPAgent-Telemetry");
        Application application = ApplicationManager.getApplication();
        if (!application.isDisposed()) {
            ThreadTracker.longRunningThreadCreated((Disposable)application, "Periodic tasks thread", "ApplicationImpl pooled thread ", "Process I/O pool ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ThreadTracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadNamePrefixes";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandThreadGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ThreadTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "longRunningThreadCreated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isWellKnownOffender";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIdleApplicationPoolThread";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIdleCommonPoolThread";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "awaitJDIThreadsTermination";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "awaitThreadTerminationWithParentParentGroup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$awaitThreadTerminationWithParentParentGroup$3";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$longRunningThreadCreated$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

