/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.editorActions.SelectWordHandler;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.navigation.GotoImplementationHandler;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.actions.ListTemplatesAction;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.usages.UsageView;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CodeInsightTestUtil {
    private CodeInsightTestUtil() {
    }

    @Nullable
    public static IntentionAction findIntentionByText(@NotNull List<IntentionAction> actions, @NonNls @NotNull String text2) {
        if (actions == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(1);
        }
        for (IntentionAction action : actions) {
            String s = action.getText();
            if (!s.equals(text2)) continue;
            return action;
        }
        return null;
    }

    public static void doIntentionTest(CodeInsightTestFixture fixture, @NonNls String file2, @NonNls String actionText) {
        String extension = FileUtilRt.getExtension((String)file2);
        file2 = FileUtil.getNameWithoutExtension((String)file2);
        if (extension.isEmpty()) {
            extension = "xml";
        }
        CodeInsightTestUtil.doIntentionTest(fixture, actionText, file2 + "." + extension, file2 + "_after." + extension);
    }

    public static void doIntentionTest(@NotNull CodeInsightTestFixture fixture, @NonNls String action, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(2);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(3);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(4);
        }
        fixture.configureByFile(before);
        List<IntentionAction> availableIntentions = fixture.getAvailableIntentions();
        IntentionAction intentionAction = CodeInsightTestUtil.findIntentionByText(availableIntentions, action);
        if (intentionAction == null) {
            Assert.fail((String)("Action not found: " + action + " in place: " + fixture.getElementAtCaret() + " among " + availableIntentions));
        }
        fixture.launchAction(intentionAction);
        fixture.checkResultByFile(after2, false);
    }

    public static void doWordSelectionTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, String ... after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(5);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(6);
        }
        assert (after2 != null && after2.length > 0);
        fixture.configureByFile(before);
        SelectWordHandler action = new SelectWordHandler(null);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)fixture.getEditor().getComponent());
        for (String file2 : after2) {
            action.execute(fixture.getEditor(), dataContext);
            fixture.checkResultByFile(file2, false);
        }
    }

    public static void doWordSelectionTestOnDirectory(@NotNull CodeInsightTestFixture fixture, @NotNull String directoryName, @NotNull String filesExtension) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(7);
        }
        if (directoryName == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(8);
        }
        if (filesExtension == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(9);
        }
        SelectWordHandler action = new SelectWordHandler(null);
        fixture.copyDirectoryToProject(directoryName, directoryName);
        fixture.configureByFile(directoryName + "/before." + filesExtension);
        int i = 1;
        while (true) {
            String fileName = directoryName + "/after" + i + "." + filesExtension;
            if (!new File(fixture.getTestDataPath() + "/" + fileName).exists()) break;
            action.execute(fixture.getEditor(), DataManager.getInstance().getDataContext((Component)fixture.getEditor().getComponent()));
            fixture.checkResultByFile(fileName);
            ++i;
        }
        junit.framework.Assert.assertTrue((String)"At least one 'after'-file required", (i > 1 ? 1 : 0) != 0);
    }

    public static void doSurroundWithTest(final @NotNull CodeInsightTestFixture fixture, final @NotNull Surrounder surrounder, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(10);
        }
        if (surrounder == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(11);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(12);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(13);
        }
        fixture.configureByFile(before);
        new WriteCommandAction.Simple(fixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                SurroundWithHandler.invoke(fixture.getProject(), fixture.getEditor(), fixture.getFile(), surrounder);
            }
        }.execute();
        fixture.checkResultByFile(after2, false);
    }

    public static void doLiveTemplateTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(14);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(15);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(16);
        }
        fixture.configureByFile(before);
        new ListTemplatesAction().actionPerformedImpl(fixture.getProject(), fixture.getEditor());
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(fixture.getEditor());
        assert (lookup != null);
        lookup.finishLookup('\n');
        fixture.checkResultByFile(after2, false);
    }

    public static void doSmartEnterTest(final @NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(17);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(18);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(19);
        }
        fixture.configureByFile(before);
        final List processors = SmartEnterProcessors.INSTANCE.forKey((Object)fixture.getFile().getLanguage());
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                Editor editor = fixture.getEditor();
                for (SmartEnterProcessor processor2 : processors) {
                    processor2.process(this.getProject(), editor, fixture.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/CodeInsightTestUtil$2", "run"));
            }
        }.execute();
        fixture.checkResultByFile(after2, false);
    }

    public static void doFormattingTest(final @NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(20);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(21);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(22);
        }
        fixture.configureByFile(before);
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                CodeStyleManager.getInstance((Project)fixture.getProject()).reformat((PsiElement)fixture.getFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/CodeInsightTestUtil$3", "run"));
            }
        }.execute();
        fixture.checkResultByFile(after2, false);
    }

    public static void doInlineRename(VariableInplaceRenameHandler handler2, String newName, CodeInsightTestFixture fixture) {
        CodeInsightTestUtil.doInlineRename(handler2, newName, fixture.getEditor(), fixture.getElementAtCaret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInlineRename(VariableInplaceRenameHandler handler2, final String newName, @NotNull Editor editor, PsiElement elementAtCaret) {
        if (editor == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(23);
        }
        Project project2 = editor.getProject();
        TemplateManagerImpl templateManager = (TemplateManagerImpl)TemplateManager.getInstance(project2);
        try {
            templateManager.setTemplateTesting(true);
            handler2.doRename(elementAtCaret, editor, DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            TemplateState state = TemplateManagerImpl.getTemplateState(editor);
            assert (state != null);
            final TextRange range = state.getCurrentVariableRange();
            assert (range != null);
            final Editor finalEditor = editor;
            new WriteCommandAction.Simple(project2, new PsiFile[0]){

                protected void run() throws Throwable {
                    finalEditor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newName);
                }
            }.execute().throwException();
            state = TemplateManagerImpl.getTemplateState(editor);
            assert (state != null);
            state.gotoEnd(false);
        }
        finally {
            templateManager.setTemplateTesting(false);
        }
    }

    public static void doInlineRenameTest(VariableInplaceRenameHandler handler2, String file2, String extension, String newName, CodeInsightTestFixture fixture) {
        fixture.configureByFile(file2 + "." + extension);
        CodeInsightTestUtil.doInlineRename(handler2, newName, fixture);
        fixture.checkResultByFile(file2 + "_after." + extension);
    }

    public static void doActionTest(AnAction action, String file2, CodeInsightTestFixture fixture) {
        String extension = FileUtilRt.getExtension((String)file2);
        String name2 = FileUtil.getNameWithoutExtension((String)file2);
        fixture.configureByFile(file2);
        fixture.testAction(action);
        fixture.checkResultByFile(name2 + "_after." + extension);
    }

    public static void addTemplate(final Template template, Disposable parentDisposable) {
        final TemplateSettings settings = TemplateSettings.getInstance();
        settings.addTemplate(template);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                settings.removeTemplate(template);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static GotoTargetHandler.GotoData gotoImplementation(Editor editor, PsiFile file2) {
        GotoTargetHandler.GotoData data = new GotoImplementationHandler().getSourceAndTargetElements(editor, file2);
        if (data.listUpdaterTask != null) {
            JBList list2 = new JBList();
            CollectionListModel model = new CollectionListModel(new ArrayList());
            list2.setModel((ListModel)model);
            list2.setModel((ListModel)new NameFilteringListModel((JList)list2, Function.ID, Condition.FALSE, String::new));
            JBPopup popup2 = new ComponentPopupBuilderImpl((JComponent)list2, null).createPopup();
            data.listUpdaterTask.init((AbstractPopup)popup2, list2, (Ref<UsageView>)new Ref());
            data.listUpdaterTask.queue();
            try {
                while (!data.listUpdaterTask.isFinished()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
            }
            finally {
                Disposer.dispose((Disposable)popup2);
            }
        }
        GotoTargetHandler.GotoData gotoData = data;
        if (gotoData == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(24);
        }
        return gotoData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesExtension";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surrounder";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/CodeInsightTestUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/CodeInsightTestUtil";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "gotoImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findIntentionByText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doIntentionTest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doWordSelectionTest";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doWordSelectionTestOnDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doSurroundWithTest";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doLiveTemplateTest";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doSmartEnterTest";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doFormattingTest";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doInlineRename";
                break;
            }
            case 24: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

