/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestDialog;
import com.intellij.testIntegration.createTest.TestGenerator;
import com.intellij.testIntegration.createTest.TestGenerators;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateTestAction
extends PsiElementBaseIntentionAction {
    private static final String CREATE_TEST_IN_THE_SAME_ROOT = "create.test.in.the.same.root";

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]);
        if (string == null) {
            CreateTestAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CreateTestAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            CreateTestAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CreateTestAction.$$$reportNull$$$0(3);
        }
        if (!CreateTestAction.isAvailableForElement(element)) {
            return false;
        }
        PsiClass psiClass = CreateTestAction.getContainingClass(element);
        assert (psiClass != null);
        PsiElement leftBrace = psiClass.getLBrace();
        if (leftBrace == null) {
            return false;
        }
        return element.getTextOffset() < leftBrace.getTextOffset();
    }

    public static boolean isAvailableForElement(PsiElement element) {
        if (((TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME)).length == 0) {
            return false;
        }
        if (element == null) {
            return false;
        }
        PsiClass psiClass = CreateTestAction.getContainingClass(element);
        if (psiClass == null) {
            return false;
        }
        PsiFile file2 = psiClass.getContainingFile();
        if (file2.getContainingDirectory() == null || JavaProjectRootsUtil.isOutsideJavaSourceRoot(file2)) {
            return false;
        }
        if (psiClass.isAnnotationType() || psiClass instanceof PsiAnonymousClass) {
            return false;
        }
        return TestFrameworks.detectFramework((PsiClass)psiClass) == null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        CreateTestDialog d;
        Module srcModule;
        if (project2 == null) {
            CreateTestAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            CreateTestAction.$$$reportNull$$$0(5);
        }
        if ((srcModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        PsiClass srcClass = CreateTestAction.getContainingClass(element);
        if (srcClass == null) {
            return;
        }
        PsiDirectory srcDir = element.getContainingFile().getContainingDirectory();
        PsiPackage srcPackage = JavaDirectoryService.getInstance().getPackage(srcDir);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project2);
        Module testModule = CreateTestAction.suggestModuleForTests(project2, srcModule);
        List<VirtualFile> testRootUrls = CreateTestAction.computeTestRoots(testModule);
        if (testRootUrls.isEmpty() && CreateTestAction.computeSuitableTestRootUrls(testModule).isEmpty()) {
            testModule = srcModule;
            if (!propertiesComponent.getBoolean(CREATE_TEST_IN_THE_SAME_ROOT)) {
                if (Messages.showOkCancelDialog((Project)project2, (String)"Create test in the same source root?", (String)"No Test Roots Found", (Icon)Messages.getQuestionIcon()) != 0) {
                    return;
                }
                propertiesComponent.setValue(CREATE_TEST_IN_THE_SAME_ROOT, true);
            }
        }
        if (!(d = this.createTestDialog(project2, testModule, srcClass, srcPackage)).showAndGet()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (project2 == null) {
                CreateTestAction.$$$reportNull$$$0(14);
            }
            TestFramework framework = d.getSelectedTestFrameworkDescriptor();
            TestGenerator generator = (TestGenerator)TestGenerators.INSTANCE.forLanguage(framework.getLanguage());
            DumbService.getInstance((Project)project2).withAlternativeResolveEnabled(() -> {
                if (project2 == null) {
                    CreateTestAction.$$$reportNull$$$0(15);
                }
                generator.generateTest(project2, d);
            });
        }, CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]), (Object)this);
    }

    @NotNull
    public static Module suggestModuleForTests(@NotNull Project project2, @NotNull Module productionModule) {
        if (project2 == null) {
            CreateTestAction.$$$reportNull$$$0(6);
        }
        if (productionModule == null) {
            CreateTestAction.$$$reportNull$$$0(7);
        }
        for (Module module3 : ModuleManager.getInstance((Project)project2).getModules()) {
            if (!productionModule.equals(TestModuleProperties.getInstance(module3).getProductionModule())) continue;
            Module module4 = module3;
            if (module4 == null) {
                CreateTestAction.$$$reportNull$$$0(8);
            }
            return module4;
        }
        if (CreateTestAction.computeSuitableTestRootUrls(productionModule).isEmpty()) {
            HashSet modules = new HashSet();
            ModuleUtilCore.collectModulesDependsOn((Module)productionModule, modules);
            modules.remove(productionModule);
            List modulesWithTestRoot = modules.stream().filter(module2 -> !CreateTestAction.computeSuitableTestRootUrls(module2).isEmpty()).limit(2L).collect(Collectors.toList());
            if (modulesWithTestRoot.size() == 1) {
                Module module5 = (Module)modulesWithTestRoot.get(0);
                if (module5 == null) {
                    CreateTestAction.$$$reportNull$$$0(9);
                }
                return module5;
            }
        }
        Module module6 = productionModule;
        if (module6 == null) {
            CreateTestAction.$$$reportNull$$$0(10);
        }
        return module6;
    }

    protected CreateTestDialog createTestDialog(Project project2, Module srcModule, PsiClass srcClass, PsiPackage srcPackage) {
        return new CreateTestDialog(project2, this.getText(), srcClass, srcPackage, srcModule);
    }

    static List<String> computeSuitableTestRootUrls(@NotNull Module module2) {
        if (module2 == null) {
            CreateTestAction.$$$reportNull$$$0(11);
        }
        return CreateTestAction.suitableTestSourceFolders(module2).map(ContentFolder::getUrl).collect(Collectors.toList());
    }

    static List<VirtualFile> computeTestRoots(@NotNull Module mainModule) {
        if (mainModule == null) {
            CreateTestAction.$$$reportNull$$$0(12);
        }
        if (!CreateTestAction.computeSuitableTestRootUrls(mainModule).isEmpty()) {
            return CreateTestAction.suitableTestSourceFolders(mainModule).map(ContentFolder::getFile).filter(Objects::nonNull).collect(Collectors.toList());
        }
        HashSet modules = new HashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)mainModule, modules);
        return modules.stream().flatMap(CreateTestAction::suitableTestSourceFolders).map(ContentFolder::getFile).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Stream<SourceFolder> suitableTestSourceFolders(@NotNull Module module2) {
        if (module2 == null) {
            CreateTestAction.$$$reportNull$$$0(13);
        }
        Predicate<SourceFolder> forGeneratedSources = JavaProjectRootsUtil::isForGeneratedSources;
        return Arrays.stream(ModuleRootManager.getInstance((Module)module2).getContentEntries()).flatMap(entry -> entry.getSourceFolders((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE).stream()).filter(forGeneratedSources.negate());
    }

    @Deprecated
    protected static void checkForTestRoots(Module srcModule, Set<VirtualFile> testFolders) {
        testFolders.addAll(CreateTestAction.computeTestRoots(srcModule));
    }

    @Nullable
    protected static PsiClass getContainingClass(PsiElement element) {
        return TestIntegrationUtils.findOuterClass(element);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testIntegration/createTest/CreateTestAction";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productionModule";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testIntegration/createTest/CreateTestAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestModuleForTests";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestModuleForTests";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeSuitableTestRootUrls";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeTestRoots";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suitableTestSourceFolders";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$1";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

