/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.FullScreenAdapter;
import com.apple.eawt.FullScreenListener;
import com.apple.eawt.FullScreenUtilities;
import com.apple.eawt.OpenURIHandler;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.CustomProtocolHandler;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MacMainFrameDecorator
extends IdeFrameDecorator
implements UISettingsListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.mac.MacMainFrameDecorator");
    private final FullscreenQueue<Runnable> myFullscreenQueue;
    private final EventDispatcher<FSListener> myDispatcher;
    private final Callback windowWillEnterFullScreenCallBack;
    private final Callback windowWillExitFullScreenCallBack;
    public static final String FULL_SCREEN = "Idea.Is.In.FullScreen.Mode.Now";
    private static boolean HAS_FULLSCREEN_UTILITIES;
    private static Method requestToggleFullScreenMethod;
    public static final boolean FULL_SCREEN_AVAILABLE;
    private static boolean SHOWN;
    private static Callback SET_VISIBLE_CALLBACK;
    private static Callback IS_VISIBLE;
    private static AtomicInteger UNIQUE_COUNTER;
    public static final Runnable TOOLBAR_SETTER;
    public static final Runnable NAVBAR_SETTER;
    public static final Function<Object, Boolean> NAVBAR_GETTER;
    public static final Function<Object, Boolean> TOOLBAR_GETTER;
    private static Runnable CURRENT_SETTER;
    private static Function<Object, Boolean> CURRENT_GETTER;
    private static CustomProtocolHandler ourProtocolHandler;
    private boolean myInFullScreen;

    private void enterFullscreen() {
        this.myInFullScreen = true;
        this.myFrame.storeFullScreenStateIfNeeded();
        this.myFullscreenQueue.runFromQueue();
    }

    private void exitFullscreen() {
        this.myInFullScreen = false;
        this.myFrame.storeFullScreenStateIfNeeded();
        JRootPane rootPane = this.myFrame.getRootPane();
        if (rootPane != null) {
            rootPane.putClientProperty(FULL_SCREEN, null);
        }
        this.myFullscreenQueue.runFromQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MacMainFrameDecorator(final @NotNull IdeFrameImpl frame, boolean navBar) {
        if (frame == null) {
            MacMainFrameDecorator.$$$reportNull$$$0(0);
        }
        super(frame);
        this.myFullscreenQueue = new FullscreenQueue();
        this.myDispatcher = EventDispatcher.create(FSListener.class);
        this.windowWillEnterFullScreenCallBack = new Callback(){

            public void callback(ID self, ID nsNotification) {
                Foundation.invoke((ID)self, (String)"oldWindowWillEnterFullScreen:", (Object[])new Object[]{nsNotification});
                MacMainFrameDecorator.this.enterFullscreen();
            }
        };
        this.windowWillExitFullScreenCallBack = new Callback(){

            public void callback(ID self, ID nsNotification) {
                Foundation.invoke((ID)self, (String)"oldWindowWillExitFullScreen:", (Object[])new Object[]{nsNotification});
                MacMainFrameDecorator.this.exitFullscreen();
            }
        };
        if (CURRENT_SETTER == null) {
            CURRENT_SETTER = navBar ? NAVBAR_SETTER : TOOLBAR_SETTER;
            CURRENT_GETTER = navBar ? NAVBAR_GETTER : TOOLBAR_GETTER;
            SHOWN = (Boolean)CURRENT_GETTER.fun(null);
        }
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, (Object)this);
        ID pool = Foundation.invoke((String)"NSAutoreleasePool", (String)"new", (Object[])new Object[0]);
        int v = UNIQUE_COUNTER.incrementAndGet();
        try {
            if (SystemInfo.isMacOSLion) {
                if (!FULL_SCREEN_AVAILABLE) {
                    return;
                }
                FullScreenUtilities.setWindowCanFullScreen((Window)frame, (boolean)true);
                FullScreenUtilities.addFullScreenListenerTo((Window)frame, (FullScreenListener)new FullScreenListener(){

                    public void windowEnteringFullScreen(AppEvent.FullScreenEvent event) {
                        ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowEnteringFullScreen(event);
                    }

                    public void windowEnteredFullScreen(AppEvent.FullScreenEvent event) {
                        ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowEnteredFullScreen(event);
                    }

                    public void windowExitingFullScreen(AppEvent.FullScreenEvent event) {
                        ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowExitingFullScreen(event);
                    }

                    public void windowExitedFullScreen(AppEvent.FullScreenEvent event) {
                        ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowExitedFullScreen(event);
                    }
                });
                this.myDispatcher.addListener((EventListener)new FSAdapter(){

                    public void windowEnteredFullScreen(AppEvent.FullScreenEvent event) {
                        JRootPane rootPane = frame.getRootPane();
                        if (rootPane != null) {
                            rootPane.putClientProperty(MacMainFrameDecorator.FULL_SCREEN, Boolean.TRUE);
                        }
                        MacMainFrameDecorator.this.enterFullscreen();
                        MacMainFrameDecorator.this.myFrame.validate();
                    }

                    public void windowExitedFullScreen(AppEvent.FullScreenEvent event) {
                        if (MacMainFrameDecorator.this.myFrame == null) {
                            return;
                        }
                        MacMainFrameDecorator.this.exitFullscreen();
                        MacMainFrameDecorator.this.myFrame.validate();
                    }
                });
            } else {
                ID window = MacUtil.findWindowForTitle((String)frame.getTitle());
                if (window == null) {
                    return;
                }
                String className = "IdeaToolbar" + v;
                ID ownToolbar = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSToolbar"), (String)className);
                Foundation.registerObjcClassPair((ID)ownToolbar);
                ID toolbar = Foundation.invoke((ID)Foundation.invoke((String)className, (String)"alloc", (Object[])new Object[0]), (String)"initWithIdentifier:", (Object[])new Object[]{Foundation.nsString((String)className)});
                Foundation.cfRetain((ID)toolbar);
                Foundation.invoke((ID)toolbar, (String)"setVisible:", (Object[])new Object[]{0});
                Foundation.addMethod((ID)ownToolbar, (Pointer)Foundation.createSelector((String)"setVisible:"), (Callback)SET_VISIBLE_CALLBACK, (String)"v*");
                Foundation.addMethod((ID)ownToolbar, (Pointer)Foundation.createSelector((String)"isVisible"), (Callback)IS_VISIBLE, (String)"B*");
                Foundation.executeOnMainThread((boolean)true, (boolean)true, () -> {
                    Foundation.invoke((ID)window, (String)"setToolbar:", (Object[])new Object[]{toolbar});
                    Foundation.invoke((ID)window, (String)"setShowsToolbarButton:", (Object[])new Object[]{1});
                });
            }
        }
        finally {
            Foundation.invoke((ID)pool, (String)"release", (Object[])new Object[0]);
        }
        MacMainFrameDecorator.createProtocolHandler();
    }

    private static void createProtocolHandler() {
        if (ourProtocolHandler == null) {
            ID mainBundle = Foundation.invoke((String)"NSBundle", (String)"mainBundle", (Object[])new Object[0]);
            ID urlTypes = Foundation.invoke((ID)mainBundle, (String)"objectForInfoDictionaryKey:", (Object[])new Object[]{Foundation.nsString((String)"CFBundleURLTypes")});
            BuildNumber build = ApplicationInfoImpl.getShadowInstance().getBuild();
            if (urlTypes.equals((Object)ID.NIL) && build != null && !build.isSnapshot()) {
                LOG.warn("no url bundle present. \nTo use platform protocol handler to open external links specify required protocols in the mac app layout section of the build file\nExample: args.urlSchemes = [\"your-protocol\"] will handle following links: your-protocol://open?file=file&line=line");
                return;
            }
            ourProtocolHandler = new CustomProtocolHandler();
            Application.getApplication().setOpenURIHandler(new OpenURIHandler(){

                public void openURI(AppEvent.OpenURIEvent event) {
                    TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> ourProtocolHandler.openLink(event.getURI()));
                }
            });
        }
    }

    private void replaceNativeFullscreenListenerCallback() {
        ID awtWindow = Foundation.getObjcClass((String)"AWTWindow");
        Pointer windowWillEnterFullScreenMethod = Foundation.createSelector((String)"windowWillEnterFullScreen:");
        ID originalWindowWillEnterFullScreen = Foundation.class_replaceMethod((ID)awtWindow, (Pointer)windowWillEnterFullScreenMethod, (Callback)this.windowWillEnterFullScreenCallBack, (String)"v@::@");
        Foundation.addMethodByID((ID)awtWindow, (Pointer)Foundation.createSelector((String)"oldWindowWillEnterFullScreen:"), (ID)originalWindowWillEnterFullScreen, (String)"v@::@");
        Pointer windowWillExitFullScreenMethod = Foundation.createSelector((String)"windowWillExitFullScreen:");
        ID originalWindowWillExitFullScreen = Foundation.class_replaceMethod((ID)awtWindow, (Pointer)windowWillExitFullScreenMethod, (Callback)this.windowWillExitFullScreenCallBack, (String)"v@::@");
        Foundation.addMethodByID((ID)awtWindow, (Pointer)Foundation.createSelector((String)"oldWindowWillExitFullScreen:"), (ID)originalWindowWillExitFullScreen, (String)"v@::@");
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        if (CURRENT_GETTER != null) {
            SHOWN = (Boolean)CURRENT_GETTER.fun(null);
        }
    }

    @Override
    public boolean isInFullScreen() {
        return this.myInFullScreen;
    }

    @Override
    public ActionCallback toggleFullScreen(boolean state) {
        if (!SystemInfo.isMacOSLion || this.myFrame == null || this.myInFullScreen == state) {
            return ActionCallback.REJECTED;
        }
        final ActionCallback callback = new ActionCallback();
        this.myDispatcher.addListener((EventListener)new FSAdapter(){

            public void windowExitedFullScreen(AppEvent.FullScreenEvent event) {
                callback.setDone();
                MacMainFrameDecorator.this.myDispatcher.removeListener((EventListener)this);
            }

            public void windowEnteredFullScreen(AppEvent.FullScreenEvent event) {
                callback.setDone();
                MacMainFrameDecorator.this.myDispatcher.removeListener((EventListener)this);
            }
        });
        this.myFullscreenQueue.runOrEnqueue(() -> this.toggleFullScreenNow());
        return callback;
    }

    public void toggleFullScreenNow() {
        try {
            requestToggleFullScreenMethod.invoke((Object)Application.getApplication(), this.myFrame);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    static {
        try {
            Class.forName("com.apple.eawt.FullScreenUtilities");
            requestToggleFullScreenMethod = Application.class.getMethod("requestToggleFullScreen", Window.class);
            HAS_FULLSCREEN_UTILITIES = true;
        }
        catch (Exception e) {
            HAS_FULLSCREEN_UTILITIES = false;
        }
        FULL_SCREEN_AVAILABLE = SystemInfo.isJavaVersionAtLeast((String)"1.6.0_29") && HAS_FULLSCREEN_UTILITIES;
        SHOWN = false;
        SET_VISIBLE_CALLBACK = new Callback(){

            public void callback(ID caller, ID selector2, ID value2) {
                SHOWN = value2.intValue() == 1;
                SwingUtilities.invokeLater(CURRENT_SETTER);
            }
        };
        IS_VISIBLE = new Callback(){

            public boolean callback(ID caller) {
                return SHOWN;
            }
        };
        UNIQUE_COUNTER = new AtomicInteger(0);
        TOOLBAR_SETTER = () -> {
            UISettings settings = UISettings.getInstance();
            settings.setShowMainToolbar(SHOWN);
            settings.fireUISettingsChanged();
        };
        NAVBAR_SETTER = () -> {
            UISettings settings = UISettings.getInstance();
            settings.setShowNavigationBar(SHOWN);
            settings.fireUISettingsChanged();
        };
        NAVBAR_GETTER = new Function<Object, Boolean>(){

            public Boolean fun(Object o) {
                return UISettings.getInstance().getShowNavigationBar();
            }
        };
        TOOLBAR_GETTER = new Function<Object, Boolean>(){

            public Boolean fun(Object o) {
                return UISettings.getInstance().getShowMainToolbar();
            }
        };
        CURRENT_SETTER = null;
        CURRENT_GETTER = null;
        ourProtocolHandler = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/ui/mac/MacMainFrameDecorator", "<init>"));
    }

    private static class FullscreenQueue<T extends Runnable> {
        private boolean waitingForAppKit = false;
        private LinkedList<Runnable> queueModel = new LinkedList();

        private FullscreenQueue() {
        }

        synchronized void runOrEnqueue(T runnable2) {
            if (this.waitingForAppKit) {
                this.enqueue(runnable2);
            } else {
                ApplicationManager.getApplication().invokeLater(runnable2);
                this.waitingForAppKit = true;
            }
        }

        private synchronized void enqueue(T runnable2) {
            this.queueModel.add((Runnable)runnable2);
        }

        synchronized void runFromQueue() {
            if (!this.queueModel.isEmpty()) {
                this.queueModel.remove().run();
                this.waitingForAppKit = true;
            } else {
                this.waitingForAppKit = false;
            }
        }
    }

    private static class FSAdapter
    extends FullScreenAdapter
    implements FSListener {
        private FSAdapter() {
        }
    }

    private static interface FSListener
    extends FullScreenListener,
    EventListener {
    }
}

