/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class BegButtonUI
extends MetalButtonUI {
    private static final BegButtonUI begButtonUI = new BegButtonUI();
    private final Rectangle viewRect = new Rectangle();
    private final Rectangle textRect = new Rectangle();
    private final Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return begButtonUI;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        this.viewRect.x = i.left;
        this.viewRect.y = i.top;
        this.viewRect.width = b.getWidth() - (i.right + this.viewRect.x);
        this.viewRect.height = b.getHeight() - (i.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text2 = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, b.getText() == null ? 0 : b.getIconTextGap());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, c, this.iconRect);
        }
        if (text2 != null && !text2.equals("")) {
            this.paintText(g, c, this.textRect, text2);
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, this.viewRect, this.textRect, this.iconRect);
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        UIUtil.drawDottedRectangle((Graphics)g, (int)viewRect.x, (int)viewRect.y, (int)(viewRect.x + viewRect.width), (int)(viewRect.y + viewRect.height));
    }
}

