/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs.builder;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.io.StringRef;
import com.intellij.util.xml.Stubbed;
import com.intellij.util.xml.StubbedOccurrence;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.ElementStub;
import java.lang.reflect.Type;
import java.util.HashMap;

class DomStubBuilderVisitor {
    private final DomManagerImpl myManager;

    DomStubBuilderVisitor(DomManagerImpl manager) {
        this.myManager = manager;
    }

    void visitXmlElement(XmlElement element, ElementStub parent, int index) {
        String nsKey;
        DomInvocationHandler handler2 = this.myManager.getDomHandler(element);
        if (handler2 == null || handler2.getAnnotation(Stubbed.class) == null && !handler2.getChildDescription().isStubbed()) {
            return;
        }
        AbstractDomChildrenDescription description = handler2.getChildDescription();
        String string = nsKey = description instanceof DomChildrenDescription ? ((DomChildrenDescription)description).getXmlName().getNamespaceKey() : "";
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String elementClass = null;
            if (handler2.getAnnotation(StubbedOccurrence.class) != null) {
                Type type2 = description.getType();
                elementClass = ((Class)type2).getName();
            }
            ElementStub stub = new ElementStub(parent, StringRef.fromString((String)tag.getName()), StringRef.fromNullableString((String)nsKey), index, description instanceof CustomDomChildrenDescription, elementClass == null ? null : StringRef.fromNullableString((String)elementClass), tag.getSubTags().length == 0 ? tag.getValue().getTrimmedText() : "");
            for (XmlAttribute attribute : tag.getAttributes()) {
                this.visitXmlElement((XmlElement)attribute, stub, 0);
            }
            HashMap<String, Integer> indices2 = new HashMap<String, Integer>();
            for (XmlTag subTag : tag.getSubTags()) {
                String name2 = subTag.getName();
                Integer i = (Integer)indices2.get(name2);
                i = i == null ? 0 : i + 1;
                this.visitXmlElement((XmlElement)subTag, stub, i);
                indices2.put(name2, i);
            }
        } else if (element instanceof XmlAttribute) {
            new AttributeStub(parent, StringRef.fromString((String)((XmlAttribute)element).getLocalName()), StringRef.fromNullableString((String)nsKey), ((XmlAttribute)element).getValue());
        }
    }
}

