/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import com.intellij.vcs.commit.CommitMessageInspectionProfile;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCommitMessageAction
extends DumbAwareAction {
    public static final String NAME = "Reformat commit message";

    public ReformatCommitMessageAction() {
        super(NAME);
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getProject();
        Document document = ReformatCommitMessageAction.getCommitMessage(e);
        e.getPresentation().setEnabled(project2 != null && document != null && ReformatCommitMessageAction.getEnabledInspections(project2).anyMatch(inspection -> inspection.canReformat(project2, document)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(1);
        }
        Project project2 = (Project)ObjectUtils.notNull((Object)e.getProject());
        Document document = (Document)ObjectUtils.notNull((Object)ReformatCommitMessageAction.getCommitMessage(e));
        CommandProcessor.getInstance().executeCommand(project2, () -> WriteAction.run(() -> ReformatCommitMessageAction.reformat(project2, document)), NAME, null);
    }

    public static void reformat(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(2);
        }
        if (document == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(3);
        }
        List<BaseCommitMessageInspection> inspections = ReformatCommitMessageAction.getEnabledInspections(project2).collect(Collectors.toList());
        inspections.forEach(inspection -> {
            if (project2 == null) {
                ReformatCommitMessageAction.$$$reportNull$$$0(7);
            }
            if (document == null) {
                ReformatCommitMessageAction.$$$reportNull$$$0(8);
            }
            inspection.reformat(project2, document);
        });
    }

    @Nullable
    private static Document getCommitMessage(@NotNull AnActionEvent e) {
        CommitMessage commitMessage;
        if (e == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(4);
        }
        Editor editor = (commitMessage = (CommitMessage)ObjectUtils.tryCast((Object)e.getData(VcsDataKeys.COMMIT_MESSAGE_CONTROL), CommitMessage.class)) != null ? commitMessage.getEditorField().getEditor() : null;
        return editor != null ? editor.getDocument() : null;
    }

    @NotNull
    private static Stream<BaseCommitMessageInspection> getEnabledInspections(@NotNull Project project2) {
        if (project2 == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(5);
        }
        Stream<BaseCommitMessageInspection> stream = CommitMessageInspectionProfile.getInstance(project2).getAllEnabledInspectionTools(project2).stream().map(Tools::getTool).map(InspectionToolWrapper::getTool).filter(BaseCommitMessageInspection.class::isInstance).map(BaseCommitMessageInspection.class::cast);
        if (stream == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(6);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/commit/ReformatCommitMessageAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/commit/ReformatCommitMessageAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledInspections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommitMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledInspections";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reformat$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

