/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogStorageImpl
implements Disposable,
VcsLogStorage {
    @NotNull
    private static final Logger LOG = Logger.getInstance(VcsLogStorage.class);
    @NotNull
    private static final String HASHES_STORAGE = "hashes";
    @NotNull
    private static final String REFS_STORAGE = "refs";
    @NotNull
    public static final VcsLogStorage EMPTY = new EmptyLogStorage();
    public static final int VERSION = 5;
    public static final int NO_INDEX = -1;
    private static final int REFS_VERSION = 1;
    @NotNull
    private final PersistentEnumeratorBase<CommitId> myCommitIdEnumerator;
    @NotNull
    private final PersistentEnumeratorBase<VcsRef> myRefsEnumerator;
    @NotNull
    private final FatalErrorHandler myExceptionReporter;
    private volatile boolean myDisposed;

    public VcsLogStorageImpl(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull FatalErrorHandler exceptionReporter, @NotNull Disposable parent) throws IOException {
        if (project2 == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(0);
        }
        if (logProviders == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(1);
        }
        if (exceptionReporter == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(3);
        }
        this.myDisposed = false;
        this.myExceptionReporter = exceptionReporter;
        List roots = ((StreamEx)StreamEx.ofKeys(logProviders).sortedBy(VirtualFile::getPath)).toList();
        String logId = PersistentUtil.calcLogId(project2, logProviders);
        MyCommitIdKeyDescriptor commitIdKeyDescriptor = new MyCommitIdKeyDescriptor(roots);
        this.myCommitIdEnumerator = PersistentUtil.createPersistentEnumerator(commitIdKeyDescriptor, HASHES_STORAGE, logId, 5);
        this.myRefsEnumerator = PersistentUtil.createPersistentEnumerator(new VcsRefKeyDescriptor(logProviders, commitIdKeyDescriptor), REFS_STORAGE, logId, 6);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    public static Function<Integer, Hash> createHashGetter(@NotNull VcsLogStorage storage2) {
        if (storage2 == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(4);
        }
        Function function = commitIndex -> {
            CommitId commitId;
            if (storage2 == null) {
                VcsLogStorageImpl.$$$reportNull$$$0(12);
            }
            if ((commitId = storage2.getCommitId((int)commitIndex)) == null) {
                return null;
            }
            return commitId.getHash();
        };
        if (function == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(5);
        }
        return function;
    }

    @Nullable
    private CommitId doGetCommitId(int index) throws IOException {
        return (CommitId)this.myCommitIdEnumerator.valueOf(index);
    }

    private int getOrPut(@NotNull Hash hash, @NotNull VirtualFile root) throws IOException {
        if (hash == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(6);
        }
        if (root == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(7);
        }
        return this.myCommitIdEnumerator.enumerate((Object)new CommitId(hash, root));
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(8);
        }
        if (root == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(9);
        }
        this.checkDisposed();
        try {
            return this.getOrPut(hash, root);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public CommitId getCommitId(int commitIndex) {
        this.checkDisposed();
        try {
            CommitId commitId = this.doGetCommitId(commitIndex);
            if (commitId == null) {
                this.myExceptionReporter.consume(this, new RuntimeException("Unknown commit index: " + commitIndex));
            }
            return commitId;
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return null;
        }
    }

    @Override
    @Nullable
    public CommitId findCommitId(final @NotNull Condition<CommitId> condition2) {
        if (condition2 == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(10);
        }
        this.checkDisposed();
        try {
            final Ref hashRef = Ref.create();
            this.myCommitIdEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<CommitId>(){

                protected boolean accept(CommitId commitId) {
                    boolean matches = condition2.value((Object)commitId);
                    if (matches) {
                        hashRef.set((Object)commitId);
                    }
                    return matches;
                }
            });
            return (CommitId)hashRef.get();
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return null;
        }
    }

    @Override
    public int getRefIndex(@NotNull VcsRef ref) {
        if (ref == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(11);
        }
        this.checkDisposed();
        try {
            return this.myRefsEnumerator.enumerate((Object)ref);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public VcsRef getVcsRef(int refIndex) {
        this.checkDisposed();
        try {
            return (VcsRef)this.myRefsEnumerator.valueOf(refIndex);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return null;
        }
    }

    @Override
    public void flush() {
        this.checkDisposed();
        this.myCommitIdEnumerator.force();
        this.myRefsEnumerator.force();
    }

    public void dispose() {
        try {
            this.myDisposed = true;
            this.myCommitIdEnumerator.close();
            this.myRefsEnumerator.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionReporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogStorageImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashGetter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHashGetter";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrPut";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommitIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findCommitId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRefIndex";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createHashGetter$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VcsRefKeyDescriptor
    implements KeyDescriptor<VcsRef> {
        @NotNull
        private final Map<VirtualFile, VcsLogProvider> myLogProviders;
        @NotNull
        private final KeyDescriptor<CommitId> myCommitIdKeyDescriptor;

        public VcsRefKeyDescriptor(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull KeyDescriptor<CommitId> commitIdKeyDescriptor) {
            if (logProviders == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(0);
            }
            if (commitIdKeyDescriptor == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(1);
            }
            this.myLogProviders = logProviders;
            this.myCommitIdKeyDescriptor = commitIdKeyDescriptor;
        }

        public int getHashCode(@NotNull VcsRef value2) {
            if (value2 == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(2);
            }
            return value2.hashCode();
        }

        public boolean isEqual(@NotNull VcsRef val1, @NotNull VcsRef val2) {
            if (val1 == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(3);
            }
            if (val2 == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(4);
            }
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, @NotNull VcsRef value2) throws IOException {
            if (out == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(5);
            }
            if (value2 == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(6);
            }
            this.myCommitIdKeyDescriptor.save(out, (Object)new CommitId(value2.getCommitHash(), value2.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value2.getName());
            this.myLogProviders.get(value2.getRoot()).getReferenceManager().serialize(out, value2.getType());
        }

        public VcsRef read(@NotNull DataInput in) throws IOException {
            CommitId commitId;
            if (in == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(7);
            }
            if ((commitId = (CommitId)this.myCommitIdKeyDescriptor.read(in)) == null) {
                throw new IOException("Can not read commit id for reference");
            }
            String name2 = IOUtil.readUTF((DataInput)in);
            VcsRefType type2 = this.myLogProviders.get(commitId.getRoot()).getReferenceManager().deserialize(in);
            return new VcsRefImpl(commitId.getHash(), name2, type2, commitId.getRoot());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logProviders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitIdKeyDescriptor";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val2";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHashCode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEqual";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EmptyLogStorage
    implements VcsLogStorage {
        private EmptyLogStorage() {
        }

        @Override
        public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
            if (hash == null) {
                EmptyLogStorage.$$$reportNull$$$0(0);
            }
            if (root == null) {
                EmptyLogStorage.$$$reportNull$$$0(1);
            }
            return 0;
        }

        @Override
        @NotNull
        public CommitId getCommitId(int commitIndex) {
            throw new UnsupportedOperationException("Illegal access to empty hash map by index " + commitIndex);
        }

        @Override
        @Nullable
        public CommitId findCommitId(@NotNull Condition<CommitId> string) {
            if (string == null) {
                EmptyLogStorage.$$$reportNull$$$0(2);
            }
            return null;
        }

        @Override
        public int getRefIndex(@NotNull VcsRef ref) {
            if (ref == null) {
                EmptyLogStorage.$$$reportNull$$$0(3);
            }
            return 0;
        }

        @Override
        @Nullable
        public VcsRef getVcsRef(int refIndex) {
            throw new UnsupportedOperationException("Illegal access to empty ref map by index " + refIndex);
        }

        @Override
        public void flush() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$EmptyLogStorage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCommitIndex";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findCommitId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRefIndex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCommitIdKeyDescriptor
    implements KeyDescriptor<CommitId> {
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final TObjectIntHashMap<VirtualFile> myRootsReversed;

        public MyCommitIdKeyDescriptor(@NotNull List<VirtualFile> roots) {
            if (roots == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(0);
            }
            this.myRoots = roots;
            this.myRootsReversed = new TObjectIntHashMap();
            for (int i = 0; i < roots.size(); ++i) {
                this.myRootsReversed.put((Object)roots.get(i), i);
            }
        }

        public void save(@NotNull DataOutput out, CommitId value2) throws IOException {
            if (out == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(1);
            }
            ((HashImpl)value2.getHash()).write(out);
            out.writeInt(this.myRootsReversed.get((Object)value2.getRoot()));
        }

        public CommitId read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(2);
            }
            Hash hash = HashImpl.read(in);
            VirtualFile root = this.myRoots.get(in.readInt());
            if (root == null) {
                return null;
            }
            return new CommitId(hash, root);
        }

        public int getHashCode(CommitId value2) {
            return value2.hashCode();
        }

        public boolean isEqual(CommitId val1, CommitId val2) {
            return val1.equals((Object)val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$MyCommitIdKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

