/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexDataGetter {
    private static final Logger LOG = Logger.getInstance(IndexDataGetter.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final VcsLogPersistentIndex.IndexStorage myIndexStorage;
    @NotNull
    private final VcsLogStorage myLogStorage;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;

    public IndexDataGetter(@NotNull Project project2, @NotNull Set<VirtualFile> roots, @NotNull VcsLogPersistentIndex.IndexStorage indexStorage, @NotNull VcsLogStorage logStorage, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        if (project2 == null) {
            IndexDataGetter.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            IndexDataGetter.$$$reportNull$$$0(1);
        }
        if (indexStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(2);
        }
        if (logStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(3);
        }
        if (fatalErrorsConsumer == null) {
            IndexDataGetter.$$$reportNull$$$0(4);
        }
        this.myProject = project2;
        this.myRoots = roots;
        this.myIndexStorage = indexStorage;
        this.myLogStorage = logStorage;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
    }

    @Nullable
    public String getFullMessage(int index) {
        return (String)this.executeAndCatch(() -> (String)this.myIndexStorage.messages.get((Object)index));
    }

    @NotNull
    public Set<FilePath> getFileNames(@NotNull FilePath path, int commit) {
        Set result2;
        VirtualFile root;
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(5);
        }
        if (this.myRoots.contains(root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path)) && (result2 = (Set)this.executeAndCatch(() -> {
            if (path == null) {
                IndexDataGetter.$$$reportNull$$$0(16);
            }
            return this.myIndexStorage.paths.getFileNames(path, commit);
        })) != null) {
            Set set2 = result2;
            if (set2 == null) {
                IndexDataGetter.$$$reportNull$$$0(6);
            }
            return set2;
        }
        Set<FilePath> set3 = Collections.emptySet();
        if (set3 == null) {
            IndexDataGetter.$$$reportNull$$$0(7);
        }
        return set3;
    }

    @NotNull
    public FileNamesData buildFileNamesData(@NotNull FilePath path) {
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(8);
        }
        FileNamesData result2 = new FileNamesData();
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        if (this.myRoots.contains(root)) {
            this.executeAndCatch(() -> {
                if (path == null) {
                    IndexDataGetter.$$$reportNull$$$0(15);
                }
                this.myIndexStorage.paths.iterateCommits(path, (changes, commit) -> this.executeAndCatch(() -> {
                    List parents2 = (List)this.myIndexStorage.parents.get((Object)commit);
                    result2.add(commit, (FilePath)changes.first, (List)changes.second, parents2);
                    return null;
                }));
                return null;
            });
        }
        FileNamesData fileNamesData = result2;
        if (fileNamesData == null) {
            IndexDataGetter.$$$reportNull$$$0(9);
        }
        return fileNamesData;
    }

    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(10);
        }
        try {
            return (T)computable.compute();
        }
        catch (StorageException | IOException e) {
            this.myIndexStorage.markCorrupted();
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException || e.getCause() instanceof StorageException) {
                this.myIndexStorage.markCorrupted();
                this.myFatalErrorsConsumer.consume(this, e);
            }
            throw e;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public List<Hash> getParents(int index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorsConsumer";
                break;
            }
            case 5: 
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFileNamesData";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildFileNamesData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAndCatch";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildFileNamesData$4";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFileNames$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class FileNamesData {
        @NotNull
        private final TIntObjectHashMap<Map<FilePath, Map<Integer, VcsLogPathsIndex.ChangeData>>> myCommitToPathAndChanges = new TIntObjectHashMap();
        private boolean myHasRenames = false;

        public boolean hasRenames() {
            return this.myHasRenames;
        }

        public void add(int commit, @NotNull FilePath path, @NotNull List<VcsLogPathsIndex.ChangeData> changes, @NotNull List<Integer> parents2) {
            Map parentToChangesMap;
            Map pathToChanges;
            if (path == null) {
                FileNamesData.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                FileNamesData.$$$reportNull$$$0(1);
            }
            if (parents2 == null) {
                FileNamesData.$$$reportNull$$$0(2);
            }
            if ((pathToChanges = (Map)this.myCommitToPathAndChanges.get(commit)) == null) {
                pathToChanges = ContainerUtil.newHashMap();
                this.myCommitToPathAndChanges.put(commit, (Object)pathToChanges);
            }
            if (!this.myHasRenames) {
                for (VcsLogPathsIndex.ChangeData data : changes) {
                    if (data == null || !data.isRename()) continue;
                    this.myHasRenames = true;
                    break;
                }
            }
            if ((parentToChangesMap = (Map)pathToChanges.get(path)) == null) {
                parentToChangesMap = ContainerUtil.newHashMap();
            }
            if (!parents2.isEmpty()) {
                LOG.assertTrue(parents2.size() == changes.size());
                for (int i = 0; i < changes.size(); ++i) {
                    VcsLogPathsIndex.ChangeData existing = (VcsLogPathsIndex.ChangeData)parentToChangesMap.get(parents2.get(i));
                    if (existing != null && existing.isRename()) continue;
                    parentToChangesMap.put(parents2.get(i), changes.get(i));
                }
            } else {
                LOG.assertTrue(changes.size() == 1);
                parentToChangesMap.put(-1, changes.get(0));
            }
            pathToChanges.put(path, parentToChangesMap);
        }

        @Nullable
        public FilePath getPathInParentRevision(int commit, int parent, @NotNull FilePath childPath) {
            if (childPath == null) {
                FileNamesData.$$$reportNull$$$0(3);
            }
            Map filesToChangesMap = (Map)this.myCommitToPathAndChanges.get(commit);
            LOG.assertTrue(filesToChangesMap != null, (Object)("Missing commit " + commit));
            Map changes = (Map)filesToChangesMap.get(childPath);
            if (changes == null) {
                return childPath;
            }
            VcsLogPathsIndex.ChangeData change = (VcsLogPathsIndex.ChangeData)changes.get(parent);
            if (change == null) {
                LOG.assertTrue(changes.size() > 1);
                return childPath;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM)) {
                return null;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_TO)) {
                return VcsUtil.getFilePath((String)((IndexDataGetter)IndexDataGetter.this).myIndexStorage.paths.getPath(change.otherPath));
            }
            return childPath;
        }

        @Nullable
        public FilePath getPathInChildRevision(int commit, int parentIndex, @NotNull FilePath parentPath) {
            if (parentPath == null) {
                FileNamesData.$$$reportNull$$$0(4);
            }
            Map filesToChangesMap = (Map)this.myCommitToPathAndChanges.get(commit);
            LOG.assertTrue(filesToChangesMap != null, (Object)("Missing commit " + commit));
            Map changes = (Map)filesToChangesMap.get(parentPath);
            if (changes == null) {
                return parentPath;
            }
            VcsLogPathsIndex.ChangeData change = (VcsLogPathsIndex.ChangeData)changes.get(parentIndex);
            if (change == null) {
                return parentPath;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_TO)) {
                return null;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM)) {
                return VcsUtil.getFilePath((String)((IndexDataGetter)IndexDataGetter.this).myIndexStorage.paths.getPath(change.otherPath));
            }
            return parentPath;
        }

        public boolean affects(int id, @NotNull FilePath path) {
            if (path == null) {
                FileNamesData.$$$reportNull$$$0(5);
            }
            return this.myCommitToPathAndChanges.containsKey(id) && ((Map)this.myCommitToPathAndChanges.get(id)).containsKey(path);
        }

        @NotNull
        public Set<Integer> getCommits() {
            HashSet result2 = ContainerUtil.newHashSet();
            this.myCommitToPathAndChanges.forEach(result2::add);
            HashSet hashSet = result2;
            if (hashSet == null) {
                FileNamesData.$$$reportNull$$$0(6);
            }
            return hashSet;
        }

        @NotNull
        public Map<Integer, FilePath> buildPathsMap() {
            HashMap result2 = ContainerUtil.newHashMap();
            this.myCommitToPathAndChanges.forEachEntry((commit, filesToChanges) -> {
                if (filesToChanges.size() == 1) {
                    result2.put(commit, ContainerUtil.getFirstItem(filesToChanges.keySet()));
                } else {
                    for (Map.Entry fileToChange : filesToChanges.entrySet()) {
                        VcsLogPathsIndex.ChangeData changeData = (VcsLogPathsIndex.ChangeData)ContainerUtil.find(((Map)fileToChange.getValue()).values(), ch -> ch != null && !ch.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM));
                        if (changeData == null) continue;
                        result2.put(commit, fileToChange.getKey());
                        break;
                    }
                }
                return true;
            });
            HashMap hashMap = result2;
            if (hashMap == null) {
                FileNamesData.$$$reportNull$$$0(7);
            }
            return hashMap;
        }

        public boolean isTrivialMerge(int commit, @NotNull FilePath path) {
            if (path == null) {
                FileNamesData.$$$reportNull$$$0(8);
            }
            if (!this.myCommitToPathAndChanges.containsKey(commit)) {
                return false;
            }
            Map data = (Map)((Map)this.myCommitToPathAndChanges.get(commit)).get(path);
            return data != null && data.size() > 1 && data.containsValue(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parents";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childPath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentPath";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommits";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildPathsMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPathInParentRevision";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPathInChildRevision";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "affects";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isTrivialMerge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

