/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.collapsing.EdgeStorage;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EdgeStorageWrapper {
    @NotNull
    private final EdgeStorage myEdgeStorage;
    @NotNull
    private final Function<Integer, Integer> myGetNodeIndexById;
    @NotNull
    private final Function<Integer, Integer> myGetNodeIdByIndex;

    public EdgeStorageWrapper(@NotNull EdgeStorage edgeStorage, @NotNull LinearGraph graph) {
        if (edgeStorage == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(1);
        }
        this(edgeStorage, (Function<Integer, Integer>)((Function)nodeId -> {
            if (graph == null) {
                EdgeStorageWrapper.$$$reportNull$$$0(17);
            }
            return graph.getNodeIndex((int)nodeId);
        }), (Function<Integer, Integer>)((Function)nodeIndex -> {
            if (graph == null) {
                EdgeStorageWrapper.$$$reportNull$$$0(16);
            }
            return graph.getNodeId((int)nodeIndex);
        }));
    }

    public EdgeStorageWrapper(@NotNull EdgeStorage edgeStorage, @NotNull Function<Integer, Integer> getNodeIndexById, @NotNull Function<Integer, Integer> getNodeIdByIndex) {
        if (edgeStorage == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(2);
        }
        if (getNodeIndexById == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(3);
        }
        if (getNodeIdByIndex == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(4);
        }
        this.myEdgeStorage = edgeStorage;
        this.myGetNodeIndexById = getNodeIndexById;
        this.myGetNodeIdByIndex = getNodeIdByIndex;
    }

    public void removeEdge(@NotNull GraphEdge graphEdge) {
        if (graphEdge == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(5);
        }
        Pair<Integer, Integer> nodeIds = this.getNodeIds(graphEdge);
        this.myEdgeStorage.removeEdge((Integer)nodeIds.first, (Integer)nodeIds.second, graphEdge.getType());
    }

    public void createEdge(@NotNull GraphEdge graphEdge) {
        if (graphEdge == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(6);
        }
        Pair<Integer, Integer> nodeIds = this.getNodeIds(graphEdge);
        this.myEdgeStorage.createEdge((Integer)nodeIds.first, (Integer)nodeIds.second, graphEdge.getType());
    }

    public boolean hasEdge(int fromIndex, int toIndex) {
        int toId = (Integer)this.myGetNodeIdByIndex.fun((Object)toIndex);
        for (Pair<Integer, GraphEdgeType> edge : this.myEdgeStorage.getEdges((Integer)this.myGetNodeIdByIndex.fun((Object)fromIndex))) {
            if (!((GraphEdgeType)((Object)edge.second)).isNormalEdge() || !LinearGraphUtils.intEqual((Integer)edge.first, toId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter2) {
        if (filter2 == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(7);
        }
        List result2 = ContainerUtil.newSmartList();
        for (Pair<Integer, GraphEdgeType> retrievedEdge : this.myEdgeStorage.getEdges((Integer)this.myGetNodeIdByIndex.fun((Object)nodeIndex))) {
            GraphEdge edge = this.decompressEdge(nodeIndex, (Integer)retrievedEdge.first, (GraphEdgeType)((Object)retrievedEdge.second));
            if (!EdgeStorageWrapper.matchedEdge(nodeIndex, edge, filter2)) continue;
            result2.add(edge);
        }
        List list2 = result2;
        if (list2 == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public Set<GraphEdge> getEdges() {
        HashSet result2 = ContainerUtil.newHashSet();
        for (int id : this.myEdgeStorage.getKnownIds()) {
            result2.addAll(this.getAdjacentEdges((Integer)this.myGetNodeIndexById.fun((Object)id), EdgeFilter.ALL));
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    private Pair<Integer, Integer> getNodeIds(@NotNull GraphEdge graphEdge) {
        if (graphEdge == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(10);
        }
        if (graphEdge.getUpNodeIndex() != null) {
            Integer mainId = (Integer)this.myGetNodeIdByIndex.fun((Object)graphEdge.getUpNodeIndex());
            if (graphEdge.getDownNodeIndex() != null) {
                Pair pair2 = Pair.create((Object)mainId, (Object)this.myGetNodeIdByIndex.fun((Object)graphEdge.getDownNodeIndex()));
                if (pair2 == null) {
                    EdgeStorageWrapper.$$$reportNull$$$0(11);
                }
                return pair2;
            }
            Pair pair3 = Pair.create((Object)mainId, (Object)EdgeStorageWrapper.convertToInt(graphEdge.getTargetId()));
            if (pair3 == null) {
                EdgeStorageWrapper.$$$reportNull$$$0(12);
            }
            return pair3;
        }
        assert (graphEdge.getDownNodeIndex() != null);
        Pair pair4 = Pair.create((Object)this.myGetNodeIdByIndex.fun((Object)graphEdge.getDownNodeIndex()), (Object)EdgeStorageWrapper.convertToInt(graphEdge.getTargetId()));
        if (pair4 == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(13);
        }
        return pair4;
    }

    @Nullable
    private GraphEdge decompressEdge(int nodeIndex, @Nullable Integer targetId, @NotNull GraphEdgeType edgeType) {
        if (edgeType == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(14);
        }
        if (edgeType.isNormalEdge()) {
            assert (targetId != null);
            Integer anotherNodeIndex = (Integer)this.myGetNodeIndexById.fun((Object)targetId);
            if (anotherNodeIndex == null) {
                return null;
            }
            return GraphEdge.createNormalEdge(nodeIndex, anotherNodeIndex, edgeType);
        }
        return GraphEdge.createEdgeWithTargetId(nodeIndex, targetId, edgeType);
    }

    private static boolean matchedEdge(int startNodeIndex, @Nullable GraphEdge edge, @NotNull EdgeFilter filter2) {
        if (filter2 == null) {
            EdgeStorageWrapper.$$$reportNull$$$0(15);
        }
        if (edge == null) {
            return false;
        }
        if (edge.getType().isNormalEdge()) {
            return startNodeIndex == EdgeStorageWrapper.convertToInt(edge.getDownNodeIndex()) && filter2.upNormal || startNodeIndex == EdgeStorageWrapper.convertToInt(edge.getUpNodeIndex()) && filter2.downNormal;
        }
        return filter2.special;
    }

    private static int convertToInt(@Nullable Integer value2) {
        return value2 == null ? -134217728 : value2;
    }

    public void removeAll() {
        this.myEdgeStorage.removeAll();
    }

    public static EdgeStorageWrapper createSimpleEdgeStorage() {
        return new EdgeStorageWrapper(new EdgeStorage(), (Function<Integer, Integer>)Functions.id(), (Function<Integer, Integer>)Functions.id());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeStorage";
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getNodeIndexById";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getNodeIdByIndex";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphEdge";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/EdgeStorageWrapper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/EdgeStorageWrapper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjacentEdges";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeEdge";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAdjacentEdges";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodeIds";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "decompressEdge";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "matchedEdge";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

