/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.Flags;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class BitSetFlags
implements Flags {
    private final int mySize;
    @NotNull
    private final BitSet myBitSet;

    public BitSetFlags(int size) {
        if (size < 0) {
            throw new NegativeArraySizeException("size < 0: " + size);
        }
        this.mySize = size;
        this.myBitSet = new BitSet();
    }

    public BitSetFlags(int size, boolean defaultValue) {
        this(size);
        if (defaultValue) {
            this.setAll(true);
        }
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean get(int index) {
        this.checkRange(index);
        return this.myBitSet.get(index);
    }

    @Override
    public void set(int index, boolean value2) {
        this.checkRange(index);
        this.myBitSet.set(index, value2);
    }

    @Override
    public void setAll(boolean value2) {
        this.myBitSet.set(0, this.mySize, value2);
    }

    private void checkRange(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index is " + index + " which is less then zero");
        }
        if (index >= this.mySize) {
            throw new IndexOutOfBoundsException("index is " + index + " and set size is " + this.mySize);
        }
    }
}

