/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsStatusDescriptor<S> {
    @NotNull
    public List<MergedStatusInfo<S>> getMergedStatusInfo(@NotNull List<List<S>> statuses) {
        if (statuses == null) {
            VcsStatusDescriptor.$$$reportNull$$$0(0);
        }
        List<S> firstParent = statuses.get(0);
        if (statuses.size() == 1) {
            List list2 = ContainerUtil.map(firstParent, info -> new MergedStatusInfo<Object>(info));
            if (list2 == null) {
                VcsStatusDescriptor.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List affectedMap = ContainerUtil.map(statuses, infos -> {
            LinkedHashMap map = ContainerUtil.newLinkedHashMap();
            for (Object info : infos) {
                String path = this.getPath(info);
                if (path == null) continue;
                map.put(path, info);
            }
            return map;
        });
        ArrayList result2 = ContainerUtil.newArrayList();
        block0: for (String path : ((Map)affectedMap.get(0)).keySet()) {
            ArrayList statusesList = ContainerUtil.newArrayList();
            for (Map infoMap : affectedMap) {
                Object status = infoMap.get(path);
                if (status == null) continue block0;
                statusesList.add(status);
            }
            result2.add(new MergedStatusInfo<S>(this.getMergedStatusInfo(path, statusesList), statusesList));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsStatusDescriptor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private S getMergedStatusInfo(@NotNull String path, @NotNull List<S> statuses) {
        Set types;
        if (path == null) {
            VcsStatusDescriptor.$$$reportNull$$$0(3);
        }
        if (statuses == null) {
            VcsStatusDescriptor.$$$reportNull$$$0(4);
        }
        if ((types = ContainerUtil.map2Set(statuses, this::getType)).size() == 1) {
            Change.Type type2 = (Change.Type)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)types));
            if (type2.equals((Object)Change.Type.MOVED)) {
                String renamedFrom = null;
                for (S status : statuses) {
                    if (renamedFrom == null) {
                        renamedFrom = this.getFirstPath(status);
                        continue;
                    }
                    if (renamedFrom.equals(this.getFirstPath(status))) continue;
                    S s = this.createStatus(Change.Type.MODIFICATION, path, null);
                    if (s == null) {
                        VcsStatusDescriptor.$$$reportNull$$$0(5);
                    }
                    return s;
                }
            }
            S s = statuses.get(0);
            if (s == null) {
                VcsStatusDescriptor.$$$reportNull$$$0(6);
            }
            return s;
        }
        if (types.contains(Change.Type.DELETED)) {
            S s = this.createStatus(Change.Type.DELETED, path, null);
            if (s == null) {
                VcsStatusDescriptor.$$$reportNull$$$0(7);
            }
            return s;
        }
        S s = this.createStatus(Change.Type.MODIFICATION, path, null);
        if (s == null) {
            VcsStatusDescriptor.$$$reportNull$$$0(8);
        }
        return s;
    }

    @Nullable
    private String getPath(@NotNull S info) {
        if (info == null) {
            VcsStatusDescriptor.$$$reportNull$$$0(9);
        }
        switch (this.getType(info)) {
            case MODIFICATION: 
            case NEW: 
            case DELETED: {
                return this.getFirstPath(info);
            }
            case MOVED: {
                return this.getSecondPath(info);
            }
        }
        return null;
    }

    @NotNull
    protected abstract S createStatus(@NotNull Change.Type var1, @NotNull String var2, @Nullable String var3);

    @NotNull
    public abstract String getFirstPath(@NotNull S var1);

    @Nullable
    public abstract String getSecondPath(@NotNull S var1);

    @NotNull
    public abstract Change.Type getType(@NotNull S var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statuses";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsStatusDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsStatusDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedStatusInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMergedStatusInfo";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MergedStatusInfo<S> {
        @NotNull
        private final S myStatusInfo;
        @NotNull
        private final List<S> myMergedStatusInfos;

        public MergedStatusInfo(@NotNull S info, @NotNull List<S> infos) {
            if (info == null) {
                MergedStatusInfo.$$$reportNull$$$0(0);
            }
            if (infos == null) {
                MergedStatusInfo.$$$reportNull$$$0(1);
            }
            this.myStatusInfo = info;
            this.myMergedStatusInfos = new SmartList(infos);
        }

        public MergedStatusInfo(@NotNull S info) {
            if (info == null) {
                MergedStatusInfo.$$$reportNull$$$0(2);
            }
            this(info, ContainerUtil.emptyList());
        }

        @NotNull
        public S getStatusInfo() {
            S s = this.myStatusInfo;
            if (s == null) {
                MergedStatusInfo.$$$reportNull$$$0(3);
            }
            return s;
        }

        @NotNull
        public List<S> getMergedStatusInfos() {
            List<S> list2 = this.myMergedStatusInfos;
            if (list2 == null) {
                MergedStatusInfo.$$$reportNull$$$0(4);
            }
            return list2;
        }

        public String toString() {
            return "MergedStatusInfo{myStatusInfo=" + this.myStatusInfo + ", myMergedStatusInfos=" + this.myMergedStatusInfos + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsStatusDescriptor$MergedStatusInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsStatusDescriptor$MergedStatusInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatusInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedStatusInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

