/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.paint;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.impl.print.elements.TerminalEdgePrintElement;
import com.intellij.vcs.log.paint.ColorGenerator;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PaintParameters;
import com.intellij.vcs.log.paint.PositionUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGraphCellPainter
implements GraphCellPainter {
    private static final Color MARK_COLOR = JBColor.BLACK;
    private static final double ARROW_ANGLE_COS2 = 0.7;
    private static final double ARROW_LENGTH = 0.3;
    @NotNull
    private final ColorGenerator myColorGenerator;

    public SimpleGraphCellPainter(@NotNull ColorGenerator colorGenerator) {
        if (colorGenerator == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(0);
        }
        this.myColorGenerator = colorGenerator;
    }

    protected int getRowHeight() {
        return 22;
    }

    private float[] getDashLength(int edgeLength) {
        int space = this.getRowHeight() / 4 - 1;
        int dash = this.getRowHeight() / 4 + 1;
        int count = edgeLength / (2 * (dash + space));
        assert (count != 0);
        int dashApprox = (edgeLength / 2 - count * space) / count;
        return new float[]{2 * dashApprox, 2 * space};
    }

    @NotNull
    private BasicStroke getOrdinaryStroke() {
        BasicStroke basicStroke = new BasicStroke(PaintParameters.getLineThickness(this.getRowHeight()), 1, 2);
        if (basicStroke == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(1);
        }
        return basicStroke;
    }

    @NotNull
    private BasicStroke getSelectedStroke() {
        BasicStroke basicStroke = new BasicStroke(PaintParameters.getSelectedLineThickness(this.getRowHeight()), 1, 2);
        if (basicStroke == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(2);
        }
        return basicStroke;
    }

    @NotNull
    private Stroke getDashedStroke(float[] dash) {
        BasicStroke basicStroke = new BasicStroke(PaintParameters.getLineThickness(this.getRowHeight()), 1, 2, 0.0f, dash, dash[0] / 2.0f);
        if (basicStroke == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(3);
        }
        return basicStroke;
    }

    @NotNull
    private Stroke getSelectedDashedStroke(float[] dash) {
        BasicStroke basicStroke = new BasicStroke(PaintParameters.getSelectedLineThickness(this.getRowHeight()), 1, 2, 0.0f, dash, dash[0] / 2.0f);
        if (basicStroke == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(4);
        }
        return basicStroke;
    }

    private void paintUpLine(@NotNull Graphics2D g2, @NotNull Color color, int from, int to, boolean hasArrow, boolean isUsual, boolean isSelected, boolean isTerminal) {
        if (g2 == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(5);
        }
        if (color == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(6);
        }
        int nodeWidth = PaintParameters.getNodeWidth(this.getRowHeight());
        if (from == to) {
            int x = nodeWidth * from + nodeWidth / 2;
            int y1 = this.getRowHeight() / 2 - 1;
            int y2 = isTerminal ? PaintParameters.getCircleRadius(this.getRowHeight()) / 2 + 1 : 0;
            this.paintLine(g2, color, hasArrow, x, y1, x, y2, x, y2, isUsual, isSelected);
        } else {
            assert (!isTerminal);
            int x1 = nodeWidth * from + nodeWidth / 2;
            int y1 = this.getRowHeight() / 2;
            int x2 = nodeWidth * to + nodeWidth / 2;
            int y2 = -this.getRowHeight() / 2;
            this.paintLine(g2, color, hasArrow, x1, y1, x2, y2, (x1 + x2) / 2, (y1 + y2) / 2, isUsual, isSelected);
        }
    }

    private void paintDownLine(@NotNull Graphics2D g2, @NotNull Color color, int from, int to, boolean hasArrow, boolean isUsual, boolean isSelected, boolean isTerminal) {
        if (g2 == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(7);
        }
        if (color == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(8);
        }
        int nodeWidth = PaintParameters.getNodeWidth(this.getRowHeight());
        if (from == to) {
            int y2 = this.getRowHeight() - 1 - (isTerminal ? PaintParameters.getCircleRadius(this.getRowHeight()) / 2 + 1 : 0);
            int y1 = this.getRowHeight() / 2;
            int x = nodeWidth * from + nodeWidth / 2;
            this.paintLine(g2, color, hasArrow, x, y1, x, y2, x, y2, isUsual, isSelected);
        } else {
            assert (!isTerminal);
            int x1 = nodeWidth * from + nodeWidth / 2;
            int y1 = this.getRowHeight() / 2;
            int x2 = nodeWidth * to + nodeWidth / 2;
            int y2 = this.getRowHeight() + this.getRowHeight() / 2;
            this.paintLine(g2, color, hasArrow, x1, y1, x2, y2, (x1 + x2) / 2, (y1 + y2) / 2, isUsual, isSelected);
        }
    }

    private void paintLine(@NotNull Graphics2D g2, @NotNull Color color, boolean hasArrow, int x1, int y1, int x2, int y2, int startArrowX, int startArrowY, boolean isUsual, boolean isSelected) {
        if (g2 == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(9);
        }
        if (color == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(10);
        }
        g2.setColor(color);
        int length = x1 == x2 ? this.getRowHeight() : (int)Math.ceil(Math.hypot(x1 - x2, y1 - y2));
        this.setStroke(g2, isUsual || hasArrow, isSelected, length);
        g2.drawLine(x1, y1, x2, y2);
        if (hasArrow) {
            Pair<Integer, Integer> rotate1 = SimpleGraphCellPainter.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), Math.sqrt(0.30000000000000004), 0.3 * (double)this.getRowHeight());
            Pair<Integer, Integer> rotate2 = SimpleGraphCellPainter.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), -Math.sqrt(0.30000000000000004), 0.3 * (double)this.getRowHeight());
            g2.drawLine(startArrowX, startArrowY, (Integer)rotate1.first, (Integer)rotate1.second);
            g2.drawLine(startArrowX, startArrowY, (Integer)rotate2.first, (Integer)rotate2.second);
        }
    }

    @NotNull
    private static Pair<Integer, Integer> rotate(double x, double y, double centerX, double centerY, double cos, double sin, double arrowLength) {
        double translateX = x - centerX;
        double translateY = y - centerY;
        double d = Math.hypot(translateX, translateY);
        double scaleX = arrowLength * translateX / d;
        double scaleY = arrowLength * translateY / d;
        double rotateX = scaleX * cos - scaleY * sin;
        double rotateY = scaleX * sin + scaleY * cos;
        Pair pair2 = Pair.create((Object)((int)Math.round(rotateX + centerX)), (Object)((int)Math.round(rotateY + centerY)));
        if (pair2 == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(11);
        }
        return pair2;
    }

    private void paintCircle(@NotNull Graphics2D g2, int position, @NotNull Color color, boolean select) {
        if (g2 == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(12);
        }
        if (color == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(13);
        }
        int nodeWidth = PaintParameters.getNodeWidth(this.getRowHeight());
        int circleRadius = PaintParameters.getCircleRadius(this.getRowHeight());
        int selectedCircleRadius = PaintParameters.getSelectedCircleRadius(this.getRowHeight());
        int x0 = nodeWidth * position + nodeWidth / 2;
        int y0 = this.getRowHeight() / 2;
        int r = circleRadius;
        if (select) {
            r = selectedCircleRadius;
        }
        Ellipse2D.Double circle = new Ellipse2D.Double((double)(x0 - r) + 0.5, (double)(y0 - r) + 0.5, 2 * r, 2 * r);
        g2.setColor(color);
        g2.fill(circle);
    }

    private void setStroke(@NotNull Graphics2D g2, boolean usual, boolean select, int edgeLength) {
        if (g2 == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(14);
        }
        if (usual) {
            if (select) {
                g2.setStroke(this.getSelectedStroke());
            } else {
                g2.setStroke(this.getOrdinaryStroke());
            }
        } else if (select) {
            g2.setStroke(this.getSelectedDashedStroke(this.getDashLength(edgeLength)));
        } else {
            g2.setStroke(this.getDashedStroke(this.getDashLength(edgeLength)));
        }
    }

    @NotNull
    private Color getColor(@NotNull PrintElement printElement) {
        if (printElement == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(15);
        }
        Color color = this.myColorGenerator.getColor(printElement.getColorId());
        if (color == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(16);
        }
        return color;
    }

    private static boolean isUsual(@NotNull PrintElement printElement) {
        if (printElement == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(17);
        }
        if (!(printElement instanceof EdgePrintElement)) {
            return true;
        }
        EdgePrintElement.LineStyle lineStyle = ((EdgePrintElement)printElement).getLineStyle();
        return lineStyle == EdgePrintElement.LineStyle.SOLID;
    }

    @Override
    public void draw(@NotNull Graphics2D g2, @NotNull Collection<? extends PrintElement> printElements) {
        if (g2 == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(18);
        }
        if (printElements == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(19);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (PrintElement printElement2 : printElements) {
            if (printElement2.isSelected()) continue;
            this.drawElement(g2, printElement2, false);
        }
        List selected = ContainerUtil.filter(printElements, printElement -> printElement.isSelected());
        for (PrintElement printElement3 : selected) {
            this.drawElement(g2, printElement3, true);
        }
        for (PrintElement printElement3 : selected) {
            this.drawElement(g2, printElement3, false);
        }
    }

    protected void drawElement(@NotNull Graphics2D g2, @NotNull PrintElement printElement, boolean isSelected) {
        if (g2 == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(20);
        }
        if (printElement == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(21);
        }
        if (printElement instanceof EdgePrintElement) {
            if (isSelected) {
                this.printEdge(g2, MARK_COLOR, true, (EdgePrintElement)printElement);
            } else {
                this.printEdge(g2, this.getColor(printElement), false, (EdgePrintElement)printElement);
            }
        }
        if (printElement instanceof NodePrintElement) {
            int position = printElement.getPositionInCurrentRow();
            if (isSelected) {
                this.paintCircle(g2, position, MARK_COLOR, true);
            } else {
                this.paintCircle(g2, position, this.getColor(printElement), false);
            }
        }
    }

    private void printEdge(@NotNull Graphics2D g2, @NotNull Color color, boolean isSelected, @NotNull EdgePrintElement edgePrintElement) {
        if (g2 == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(22);
        }
        if (color == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(23);
        }
        if (edgePrintElement == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(24);
        }
        int from = edgePrintElement.getPositionInCurrentRow();
        int to = edgePrintElement.getPositionInOtherRow();
        boolean isUsual = SimpleGraphCellPainter.isUsual((PrintElement)edgePrintElement);
        if (edgePrintElement.getType() == EdgePrintElement.Type.DOWN) {
            this.paintDownLine(g2, color, from, to, edgePrintElement.hasArrow(), isUsual, isSelected, edgePrintElement instanceof TerminalEdgePrintElement);
        } else {
            this.paintUpLine(g2, color, from, to, edgePrintElement.hasArrow(), isUsual, isSelected, edgePrintElement instanceof TerminalEdgePrintElement);
        }
    }

    @Override
    @Nullable
    public PrintElement getElementUnderCursor(@NotNull Collection<? extends PrintElement> printElements, int x, int y) {
        if (printElements == null) {
            SimpleGraphCellPainter.$$$reportNull$$$0(25);
        }
        int nodeWidth = PaintParameters.getNodeWidth(this.getRowHeight());
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof NodePrintElement)) continue;
            int circleRadius = PaintParameters.getCircleRadius(this.getRowHeight());
            if (!PositionUtil.overNode(printElement.getPositionInCurrentRow(), x, y, this.getRowHeight(), nodeWidth, circleRadius)) continue;
            return printElement;
        }
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof EdgePrintElement)) continue;
            EdgePrintElement edgePrintElement = (EdgePrintElement)printElement;
            float lineThickness = PaintParameters.getLineThickness(this.getRowHeight());
            if (!(edgePrintElement.getType() == EdgePrintElement.Type.DOWN ? PositionUtil.overDownEdge(edgePrintElement.getPositionInCurrentRow(), edgePrintElement.getPositionInOtherRow(), x, y, this.getRowHeight(), nodeWidth, lineThickness) : PositionUtil.overUpEdge(edgePrintElement.getPositionInOtherRow(), edgePrintElement.getPositionInCurrentRow(), x, y, this.getRowHeight(), nodeWidth, lineThickness))) continue;
            return printElement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorGenerator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/paint/SimpleGraphCellPainter";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 15: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printElement";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printElements";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgePrintElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/paint/SimpleGraphCellPainter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrdinaryStroke";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedStroke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDashedStroke";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDashedStroke";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "rotate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paintUpLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "paintDownLine";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "paintLine";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "paintCircle";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setStroke";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUsual";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "draw";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "drawElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "printEdge";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getElementUnderCursor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

