/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.PairFunction;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class VcsLogUiImpl
extends AbstractVcsLogUi {
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final VcsLogUiPropertiesImpl.MainVcsLogUiPropertiesListener myPropertiesListener;

    public VcsLogUiImpl(@NotNull VcsLogData logData, @NotNull Project project2, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher) {
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            VcsLogUiImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            VcsLogUiImpl.$$$reportNull$$$0(2);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(3);
        }
        if (refresher == null) {
            VcsLogUiImpl.$$$reportNull$$$0(4);
        }
        super(logData, project2, manager, refresher);
        this.myUiProperties = uiProperties;
        this.myMainFrame = new MainFrame(logData, this, project2, uiProperties, this.myLog, this.myVisiblePack);
        for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])Extensions.getExtensions((ExtensionPointName)LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)this.myProject)) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        this.myPropertiesListener = new MyVcsLogUiPropertiesListener();
        this.myUiProperties.addChangeListener(this.myPropertiesListener);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myMainFrame.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myPropertiesListener.onShowLongEdgesChanged();
    }

    @NotNull
    public MainFrame getMainFrame() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            VcsLogUiImpl.$$$reportNull$$$0(5);
        }
        return mainFrame;
    }

    private void performLongAction(@NotNull GraphAction graphAction, @NotNull String title) {
        if (graphAction == null) {
            VcsLogUiImpl.$$$reportNull$$$0(6);
        }
        if (title == null) {
            VcsLogUiImpl.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (graphAction == null) {
                VcsLogUiImpl.$$$reportNull$$$0(22);
            }
            if (title == null) {
                VcsLogUiImpl.$$$reportNull$$$0(23);
            }
            GraphAnswer answer = this.myVisiblePack.getVisibleGraph().getActionController().performAction(graphAction);
            Runnable updater = answer.getGraphUpdater();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (title == null) {
                    VcsLogUiImpl.$$$reportNull$$$0(24);
                }
                assert (updater != null) : "Action:" + title + "\nController: " + this.myVisiblePack.getVisibleGraph().getActionController() + "\nAnswer:" + answer;
                updater.run();
                this.getTable().handleAnswer((GraphAnswer<Integer>)answer);
            });
        }, title, false, null, this.getMainFrame().getMainComponent());
    }

    public void expandAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_EXPAND), "Expanding " + (this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    public void collapseAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_COLLAPSE), "Collapsing " + (this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    @Override
    protected <T> void handleCommitNotFound(@NotNull T commitId, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (commitId == null) {
            VcsLogUiImpl.$$$reportNull$$$0(8);
        }
        if (rowGetter == null) {
            VcsLogUiImpl.$$$reportNull$$$0(9);
        }
        if (this.getFilters().isEmpty()) {
            super.handleCommitNotFound(commitId, rowGetter);
        } else {
            this.showWarningWithLink("Commit " + commitId.toString() + " does not exist or does not match active filters", "Reset filters and search again.", () -> {
                if (commitId == null) {
                    VcsLogUiImpl.$$$reportNull$$$0(18);
                }
                if (rowGetter == null) {
                    VcsLogUiImpl.$$$reportNull$$$0(19);
                }
                this.getFilterUi().setFilter(null);
                this.invokeOnChange(() -> {
                    if (commitId == null) {
                        VcsLogUiImpl.$$$reportNull$$$0(20);
                    }
                    if (rowGetter == null) {
                        VcsLogUiImpl.$$$reportNull$$$0(21);
                    }
                    this.jumpTo(commitId, rowGetter, (SettableFuture<Boolean>)SettableFuture.create());
                }, (Condition<VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
            });
        }
    }

    @Override
    public boolean isShowRootNames() {
        return this.myUiProperties.get(MainVcsLogUiProperties.SHOW_ROOT_NAMES);
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        MainVcsLogUiProperties.VcsLogHighlighterProperty property;
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(10);
        }
        return this.myUiProperties.exists(property = MainVcsLogUiProperties.VcsLogHighlighterProperty.get(id)) && this.myUiProperties.get(property) != false;
    }

    public boolean isMultipleRoots() {
        return this.myColorManager.isMultipleRoots();
    }

    public void applyFiltersAndUpdateUi(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            VcsLogUiImpl.$$$reportNull$$$0(11);
        }
        this.myRefresher.onFiltersChange(filters);
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myMainFrame.getGraphTable();
        if (vcsLogGraphTable == null) {
            VcsLogUiImpl.$$$reportNull$$$0(12);
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    protected VcsLogFilterCollection getFilters() {
        VcsLogFilterCollection vcsLogFilterCollection = this.myMainFrame.getFilterUi().getFilters();
        if (vcsLogFilterCollection == null) {
            VcsLogUiImpl.$$$reportNull$$$0(13);
        }
        return vcsLogFilterCollection;
    }

    @Override
    @NotNull
    public Component getMainComponent() {
        JComponent jComponent = this.myMainFrame.getMainComponent();
        if (jComponent == null) {
            VcsLogUiImpl.$$$reportNull$$$0(14);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myMainFrame.getToolbar();
        if (jComponent == null) {
            VcsLogUiImpl.$$$reportNull$$$0(15);
        }
        return jComponent;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogFilterUi vcsLogFilterUi = this.myMainFrame.getFilterUi();
        if (vcsLogFilterUi == null) {
            VcsLogUiImpl.$$$reportNull$$$0(16);
        }
        return vcsLogFilterUi;
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties getProperties() {
        MainVcsLogUiProperties mainVcsLogUiProperties = this.myUiProperties;
        if (mainVcsLogUiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(17);
        }
        return mainVcsLogUiProperties;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesListener);
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphAction";
                break;
            }
            case 7: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 9: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainFrame";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performLongAction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyFiltersAndUpdateUi";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleCommitNotFound$4";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performLongAction$1";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVcsLogUiPropertiesListener
    extends VcsLogUiPropertiesImpl.MainVcsLogUiPropertiesListener {
        private MyVcsLogUiPropertiesListener() {
        }

        @Override
        public void onShowDetailsChanged() {
            VcsLogUiImpl.this.myMainFrame.showDetails(VcsLogUiImpl.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        }

        @Override
        public void onShowLongEdgesChanged() {
            VcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController().setLongEdgesHidden(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_LONG_EDGES) == false);
        }

        @Override
        public void onBekChanged() {
            VcsLogUiImpl.this.myRefresher.onSortTypeChange(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE));
        }

        @Override
        public void onShowRootNamesChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().rootColumnUpdated();
        }

        @Override
        public void onHighlighterChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().repaint();
        }

        @Override
        public void onCompactReferencesViewChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().setCompactReferencesView(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
        }

        @Override
        public void onShowTagNamesChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().setShowTagNames(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
        }

        @Override
        public void onColumnWidthChanged(int column) {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().forceReLayout(column);
        }

        @Override
        public void onColumnOrderChanged() {
            VcsLogUiImpl.this.myMainFrame.getGraphTable().onColumnOrderSettingChanged();
        }

        @Override
        public void onShowChangesFromParentsChanged() {
        }

        @Override
        public void onTextFilterSettingsChanged() {
            VcsLogUiImpl.this.applyFiltersAndUpdateUi(VcsLogUiImpl.this.myMainFrame.getFilterUi().getFilters());
        }
    }
}

