/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BranchPopupBuilder {
    @NotNull
    private final VcsLogDataPack myDataPack;
    @Nullable
    private final Collection<VirtualFile> myVisibleRoots;
    @Nullable
    private final List<List<String>> myRecentItems;

    protected BranchPopupBuilder(@NotNull VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, @Nullable List<List<String>> recentItems) {
        if (dataPack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(0);
        }
        this.myDataPack = dataPack;
        this.myVisibleRoots = visibleRoots;
        this.myRecentItems = recentItems;
    }

    @NotNull
    protected abstract AnAction createAction(@NotNull String var1);

    protected void createRecentAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> recentItem) {
        if (actionGroup == null) {
            BranchPopupBuilder.$$$reportNull$$$0(1);
        }
        if (recentItem == null) {
            BranchPopupBuilder.$$$reportNull$$$0(2);
        }
        assert (this.myRecentItems == null);
    }

    @NotNull
    protected AnAction createCollapsedAction(String actionName) {
        AnAction anAction = this.createAction(actionName);
        if (anAction == null) {
            BranchPopupBuilder.$$$reportNull$$$0(3);
        }
        return anAction;
    }

    public ActionGroup build() {
        return this.createActions(BranchPopupBuilder.prepareGroups(this.myDataPack, this.myVisibleRoots, this.myRecentItems));
    }

    private static Groups prepareGroups(@NotNull VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, @Nullable List<List<String>> recentItems) {
        if (dataPack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(4);
        }
        Groups filteredGroups = new Groups();
        Collection allRefs = dataPack.getRefs().getBranches();
        for (Map.Entry<VirtualFile, Set<VcsRef>> entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = entry.getKey();
            if (visibleRoots != null && !visibleRoots.contains(root)) continue;
            Collection refs = entry.getValue();
            VcsLogProvider provider = (VcsLogProvider)dataPack.getLogProviders().get(root);
            VcsLogRefManager refManager = provider.getReferenceManager();
            List refGroups = refManager.groupForBranchFilter(refs);
            BranchPopupBuilder.putActionsForReferences(refGroups, filteredGroups);
        }
        if (recentItems != null) {
            for (List list2 : recentItems) {
                if (list2.size() == 1) {
                    String item = (String)ContainerUtil.getFirstItem((List)list2);
                    if (filteredGroups.singletonGroups.contains(item) || ContainerUtil.find(filteredGroups.expandedGroups.values(), strings -> strings.contains(item)) != null) continue;
                }
                filteredGroups.recentGroups.add(list2);
            }
        }
        return filteredGroups;
    }

    private DefaultActionGroup createActions(@NotNull Groups groups) {
        if (groups == null) {
            BranchPopupBuilder.$$$reportNull$$$0(5);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (String string : groups.singletonGroups) {
            actionGroup.add(this.createAction(string));
        }
        if (!groups.recentGroups.isEmpty()) {
            actionGroup.addSeparator("Recent");
            for (List list2 : groups.recentGroups) {
                this.createRecentAction(actionGroup, list2);
            }
        }
        for (Map.Entry entry : groups.expandedGroups.entrySet()) {
            actionGroup.addSeparator((String)entry.getKey());
            for (String actionName : (TreeSet)entry.getValue()) {
                actionGroup.add(this.createAction(actionName));
            }
        }
        actionGroup.addSeparator();
        for (Map.Entry entry : groups.collapsedGroups.entrySet()) {
            DefaultActionGroup popupGroup = new DefaultActionGroup((String)entry.getKey(), true);
            for (String actionName : (TreeSet)entry.getValue()) {
                popupGroup.add(this.createCollapsedAction(actionName));
            }
            actionGroup.add((AnAction)popupGroup);
        }
        return actionGroup;
    }

    private static void putActionsForReferences(List<RefGroup> references, Groups actions) {
        for (RefGroup refGroup : references) {
            if (refGroup instanceof SingletonRefGroup) {
                actions.singletonGroups.add(refGroup.getName());
                continue;
            }
            if (refGroup.isExpanded()) {
                BranchPopupBuilder.addToGroup(refGroup, actions.expandedGroups);
                continue;
            }
            BranchPopupBuilder.addToGroup(refGroup, actions.collapsedGroups);
        }
    }

    private static void addToGroup(RefGroup refGroup, TreeMap<String, TreeSet<String>> groupToAdd) {
        TreeSet groupActions = groupToAdd.computeIfAbsent(refGroup.getName(), key2 -> new TreeSet());
        for (VcsRef ref : refGroup.getRefs()) {
            groupActions.add(ref.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/BranchPopupBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/BranchPopupBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapsedAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRecentAction";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareGroups";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Groups {
        private final TreeSet<String> singletonGroups = ContainerUtil.newTreeSet();
        private final List<List<String>> recentGroups = ContainerUtil.newArrayList();
        private final TreeMap<String, TreeSet<String>> expandedGroups = ContainerUtil.newTreeMap();
        private final TreeMap<String, TreeSet<String>> collapsedGroups = ContainerUtil.newTreeMap();

        private Groups() {
        }
    }
}

