/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.VcsLogSpeedSearch;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexSpeedSearch
extends VcsLogSpeedSearch {
    @NotNull
    private final VcsLogIndex myIndex;
    @NotNull
    private final VcsUserRegistry myUserRegistry;
    @Nullable
    private Set<Integer> myMatchedByUserCommits;
    @Nullable
    private Collection<VcsUser> myMatchedUsers;

    public IndexSpeedSearch(@NotNull Project project2, @NotNull VcsLogIndex index, @NotNull VcsLogGraphTable component) {
        if (project2 == null) {
            IndexSpeedSearch.$$$reportNull$$$0(0);
        }
        if (index == null) {
            IndexSpeedSearch.$$$reportNull$$$0(1);
        }
        if (component == null) {
            IndexSpeedSearch.$$$reportNull$$$0(2);
        }
        super(component);
        this.myIndex = index;
        this.myUserRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project2, VcsUserRegistry.class);
        this.addChangeListener(evt -> {
            if (evt.getPropertyName().equals("enteredPrefix")) {
                String newValue = (String)evt.getNewValue();
                if (newValue != null) {
                    String oldValue = (String)evt.getOldValue();
                    Collection<Object> usersToExamine = this.myUserRegistry.getUsers();
                    if (oldValue != null && newValue.contains(oldValue) && this.myMatchedUsers != null) {
                        if (this.myMatchedUsers.isEmpty()) {
                            return;
                        }
                        usersToExamine = this.myMatchedUsers;
                    }
                    this.myMatchedUsers = ContainerUtil.filter((Collection)usersToExamine, user -> this.compare(VcsUserUtil.getShortPresentation(user), newValue));
                    this.myMatchedByUserCommits = this.myIndex.filter(Collections.singletonList(new SimpleVcsLogUserFilter(this.myMatchedUsers)));
                } else {
                    this.myMatchedByUserCommits = null;
                    this.myMatchedUsers = null;
                }
            }
        });
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        if (super.isSpeedSearchEnabled()) {
            VisiblePack visiblePack = ((VcsLogGraphTable)((Object)this.myComponent)).getModel().getVisiblePack();
            Set<VirtualFile> roots = visiblePack.getLogProviders().keySet();
            Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(roots, visiblePack.getFilters().getRootFilter(), visiblePack.getFilters().getStructureFilter());
            for (VirtualFile root : visibleRoots) {
                if (this.myIndex.isIndexed(root)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected String getElementText(@NotNull Object row) {
        if (row == null) {
            IndexSpeedSearch.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("Getting row text in a Log is unsupported since we match commit subject and author separately.");
    }

    @Nullable
    private String getCommitSubject(@NotNull Integer row) {
        Integer id;
        String message2;
        IndexDataGetter dataGetter;
        if (row == null) {
            IndexSpeedSearch.$$$reportNull$$$0(4);
        }
        if ((dataGetter = this.myIndex.getDataGetter()) != null && (message2 = dataGetter.getFullMessage(id = ((VcsLogGraphTable)((Object)this.myComponent)).getModel().getIdAtRow(row))) != null) {
            return IndexedDetails.getSubject(message2);
        }
        return super.getElementText(row);
    }

    @Override
    protected boolean isMatchingElement(Object row, String pattern) {
        String str = this.getCommitSubject((Integer)row);
        return str != null && this.compare(str, pattern) || this.myMatchedByUserCommits != null && !this.myMatchedByUserCommits.isEmpty() && this.myMatchedByUserCommits.contains(((VcsLogGraphTable)((Object)this.myComponent)).getModel().getIdAtRow((Integer)row));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/table/IndexSpeedSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommitSubject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SimpleVcsLogUserFilter
    implements VcsLogUserFilter {
        @NotNull
        private final Collection<VcsUser> myMatchedUsers;

        public SimpleVcsLogUserFilter(@NotNull Collection<VcsUser> matchedUsers) {
            if (matchedUsers == null) {
                SimpleVcsLogUserFilter.$$$reportNull$$$0(0);
            }
            this.myMatchedUsers = matchedUsers;
        }

        @NotNull
        public Collection<VcsUser> getUsers(@NotNull VirtualFile root) {
            if (root == null) {
                SimpleVcsLogUserFilter.$$$reportNull$$$0(1);
            }
            Collection<VcsUser> collection = this.myMatchedUsers;
            if (collection == null) {
                SimpleVcsLogUserFilter.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public boolean matches(@NotNull VcsCommitMetadata details) {
            if (details == null) {
                SimpleVcsLogUserFilter.$$$reportNull$$$0(3);
            }
            return this.myMatchedUsers.contains(details.getAuthor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchedUsers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/table/IndexSpeedSearch$SimpleVcsLogUserFilter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "details";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/table/IndexSpeedSearch$SimpleVcsLogUserFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsers";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

