/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XSourcePositionImpl
implements XSourcePosition {
    private final VirtualFile myFile;
    private final int myLine;
    private final int myOffset;

    private XSourcePositionImpl(@NotNull VirtualFile file2, int line, int offset) {
        if (file2 == null) {
            XSourcePositionImpl.$$$reportNull$$$0(0);
        }
        this.myFile = file2;
        this.myLine = line;
        this.myOffset = offset;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            XSourcePositionImpl.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static XSourcePositionImpl createByOffset(@Nullable VirtualFile file2, int offset) {
        if (file2 == null) {
            return null;
        }
        AccessToken lock = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document == null) {
                XSourcePositionImpl xSourcePositionImpl = null;
                return xSourcePositionImpl;
            }
            int line = DocumentUtil.isValidOffset(offset, document) ? document.getLineNumber(offset) : -1;
            XSourcePositionImpl xSourcePositionImpl = new XSourcePositionImpl(file2, line, offset);
            return xSourcePositionImpl;
        }
        finally {
            lock.finish();
        }
    }

    @Nullable
    public static XSourcePositionImpl createByElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile file2 = element.getContainingFile().getVirtualFile();
        if (file2 == null) {
            return null;
        }
        return XSourcePositionImpl.createByOffset(file2, element.getTextOffset());
    }

    @Nullable
    public static XSourcePositionImpl create(@Nullable VirtualFile file2, int line) {
        return XSourcePositionImpl.create(file2, line, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static XSourcePositionImpl create(@Nullable VirtualFile file2, int line, int column) {
        if (file2 == null) {
            return null;
        }
        AccessToken lock = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            int offset;
            if (file2 instanceof LightVirtualFile || file2 instanceof HttpVirtualFile) {
                offset = -1;
            } else {
                Document document;
                Document document2 = document = file2.isValid() ? FileDocumentManager.getInstance().getDocument(file2) : null;
                if (document == null) {
                    XSourcePositionImpl xSourcePositionImpl = null;
                    return xSourcePositionImpl;
                }
                if (line < 0) {
                    line = 0;
                }
                if (column < 0) {
                    column = 0;
                }
                int n = offset = line < document.getLineCount() ? document.getLineStartOffset(line) + column : -1;
                if (offset >= document.getTextLength()) {
                    offset = document.getTextLength() - 1;
                }
            }
            XSourcePositionImpl xSourcePositionImpl = new XSourcePositionImpl(file2, line, offset);
            return xSourcePositionImpl;
        }
        finally {
            lock.finish();
        }
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project2) {
        if (project2 == null) {
            XSourcePositionImpl.$$$reportNull$$$0(2);
        }
        OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor(project2, this);
        if (openFileDescriptor == null) {
            XSourcePositionImpl.$$$reportNull$$$0(3);
        }
        return openFileDescriptor;
    }

    @NotNull
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project2, @NotNull XSourcePosition position) {
        Navigatable navigatable;
        if (project2 == null) {
            XSourcePositionImpl.$$$reportNull$$$0(4);
        }
        if (position == null) {
            XSourcePositionImpl.$$$reportNull$$$0(5);
        }
        if ((navigatable = position.createNavigatable(project2)) instanceof OpenFileDescriptor) {
            OpenFileDescriptor openFileDescriptor = (OpenFileDescriptor)navigatable;
            if (openFileDescriptor == null) {
                XSourcePositionImpl.$$$reportNull$$$0(6);
            }
            return openFileDescriptor;
        }
        OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor(project2, position);
        if (openFileDescriptor == null) {
            XSourcePositionImpl.$$$reportNull$$$0(7);
        }
        return openFileDescriptor;
    }

    @NotNull
    public static OpenFileDescriptor doCreateOpenFileDescriptor(@NotNull Project project2, @NotNull XSourcePosition position) {
        if (project2 == null) {
            XSourcePositionImpl.$$$reportNull$$$0(8);
        }
        if (position == null) {
            XSourcePositionImpl.$$$reportNull$$$0(9);
        }
        OpenFileDescriptor openFileDescriptor = position.getOffset() != -1 ? new OpenFileDescriptor(project2, position.getFile(), position.getOffset()) : new OpenFileDescriptor(project2, position.getFile(), position.getLine(), 0);
        if (openFileDescriptor == null) {
            XSourcePositionImpl.$$$reportNull$$$0(10);
        }
        return openFileDescriptor;
    }

    public String toString() {
        return "XSourcePositionImpl[" + this.myFile + ":" + this.myLine + "(" + this.myOffset + ")]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XSourcePositionImpl";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XSourcePositionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigatable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenFileDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateOpenFileDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNavigatable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createOpenFileDescriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCreateOpenFileDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

