/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.border.EmptyBorder;

final class PsiBreadcrumbs
extends Breadcrumbs {
    boolean above = EditorSettingsExternalizable.getInstance().isBreadcrumbsAbove();

    PsiBreadcrumbs() {
    }

    void updateBorder(int offset) {
        this.setBorder(new EmptyBorder(0, offset, 0, 0));
    }

    protected void paintMarker(Graphics2D g, int x, int y, int width, int height, Crumb crumb, int thickness) {
        super.paintMarker(g, x, y, width, this.above ? height : thickness, crumb, thickness);
    }

    public Color getForeground() {
        Color foreground;
        if (!this.isForegroundSet() && (foreground = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.LINE_NUMBERS_COLOR)) != null) {
            return foreground;
        }
        return super.getForeground();
    }

    public Color getBackground() {
        Color background;
        if (!this.isBackgroundSet() && (background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND)) != null) {
            return background;
        }
        return super.getBackground();
    }

    protected Color getForeground(Crumb crumb) {
        CrumbPresentation presentation = PsiCrumb.getPresentation(crumb);
        if (presentation == null) {
            return super.getForeground(crumb);
        }
        Color background = super.getBackground(crumb);
        if (background != null) {
            return super.getForeground(crumb);
        }
        return presentation.getBackgroundColor(this.isSelected(crumb), this.isHovered(crumb), this.isAfterSelected(crumb));
    }

    protected Color getBackground(Crumb crumb) {
        CrumbPresentation presentation = PsiCrumb.getPresentation(crumb);
        if (presentation == null) {
            return super.getBackground(crumb);
        }
        Color background = super.getBackground(crumb);
        if (background == null) {
            return null;
        }
        return presentation.getBackgroundColor(this.isSelected(crumb), this.isHovered(crumb), this.isAfterSelected(crumb));
    }

    protected TextAttributes getAttributes(Crumb crumb) {
        TextAttributesKey key2 = this.getKey(crumb);
        return key2 == null ? null : EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key2);
    }

    private TextAttributesKey getKey(Crumb crumb) {
        if (this.isHovered(crumb)) {
            return EditorColors.BREADCRUMBS_HOVERED;
        }
        if (this.isSelected(crumb)) {
            return EditorColors.BREADCRUMBS_CURRENT;
        }
        if (this.isAfterSelected(crumb)) {
            return EditorColors.BREADCRUMBS_INACTIVE;
        }
        return EditorColors.BREADCRUMBS_DEFAULT;
    }
}

