/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.xml.index.SchemaTypeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLValidator;

public class XsdComplexTypeInfoBuilder
extends NanoXmlUtil.IXMLBuilderAdapter {
    private static final String SIGN = "";
    public static final String HTTP_WWW_W3_ORG_2001_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";
    private final MultiMap<SchemaTypeInfo, SchemaTypeInfo> myMap = new MultiMap();
    private NameSpaceHelper myNameSpaceHelper;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.index.XsdComplexTypeInfoBuilder");
    private String myCurrentElementName;
    private String myCurrentElementNsName;
    private String myCurrentComplexTypeName;
    private String myCurrentComplexTypeNsName;
    private String myCurrentSimpleTypeName;
    private String myCurrentSimpleTypeNsName;
    private boolean myInsideSchema;
    private boolean myInsideRestriction;
    private boolean myInsideExtension;
    private boolean myInsideContent;

    public void setNameSpaceHelper(NameSpaceHelper nameSpaceHelper) {
        this.myNameSpaceHelper = nameSpaceHelper;
    }

    public static MultiMap<SchemaTypeInfo, SchemaTypeInfo> parse(InputStream is) {
        return XsdComplexTypeInfoBuilder.parse(new InputStreamReader(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiMap<SchemaTypeInfo, SchemaTypeInfo> parse(Reader reader) {
        try {
            MultiMap<SchemaTypeInfo, SchemaTypeInfo> map;
            XsdComplexTypeInfoBuilder builder = new XsdComplexTypeInfoBuilder();
            NameSpaceHelper helper = new NameSpaceHelper();
            builder.setNameSpaceHelper(helper);
            NanoXmlUtil.parse((Reader)reader, (IXMLBuilder)builder, (IXMLValidator)helper);
            MultiMap<SchemaTypeInfo, SchemaTypeInfo> multiMap = map = builder.getMap();
            return multiMap;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private XsdComplexTypeInfoBuilder() {
    }

    public MultiMap<SchemaTypeInfo, SchemaTypeInfo> getMap() {
        return this.myMap;
    }

    public void startElement(String name2, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
        if (!HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(nsURI)) {
            return;
        }
        this.myInsideSchema = false;
        if ("schema".equals(name2)) {
            this.myInsideSchema = true;
        } else if ("complexType".equals(name2)) {
            this.myCurrentComplexTypeName = SIGN;
            this.myCurrentComplexTypeNsName = nsURI;
        } else if ("simpleType".equals(name2)) {
            this.myCurrentSimpleTypeName = SIGN;
            this.myCurrentSimpleTypeNsName = nsURI;
        } else if ("element".equals(name2)) {
            this.myCurrentElementNsName = nsURI;
            this.myCurrentElementName = SIGN;
        } else if ("restriction".equals(name2)) {
            this.myInsideRestriction = true;
        } else if ("extension".equals(name2)) {
            this.myInsideExtension = true;
        } else if ("simpleContent".equals(name2) || "complexContent".equals(name2)) {
            this.myInsideContent = true;
        }
    }

    public void endElement(String name2, String nsPrefix, String nsURI) throws Exception {
        if (!HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(nsURI)) {
            return;
        }
        if ("schema".equals(name2)) {
            this.myInsideSchema = false;
        } else if ("complexType".equals(name2)) {
            this.myCurrentComplexTypeName = null;
            this.myCurrentComplexTypeNsName = null;
        } else if ("simpleType".equals(name2)) {
            this.myCurrentSimpleTypeName = null;
            this.myCurrentSimpleTypeNsName = null;
        } else if ("element".equals(name2)) {
            this.myCurrentElementNsName = null;
            this.myCurrentElementName = null;
        } else if ("restriction".equals(name2)) {
            this.myInsideRestriction = false;
        } else if ("extension".equals(name2)) {
            this.myInsideExtension = false;
        } else if ("simpleContent".equals(name2) || "complexContent".equals(name2)) {
            this.myInsideContent = false;
        }
    }

    public void addAttribute(String key2, String nsPrefix, String nsURI, String value2, String type2) throws Exception {
        if (!StringUtil.isEmptyOrSpaces((String)nsURI) && !HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(nsURI)) {
            return;
        }
        if ("base".equals(key2)) {
            if (this.myCurrentComplexTypeName != null && this.myInsideContent && (this.myInsideExtension || this.myInsideRestriction)) {
                this.putTypeDataToMap(nsURI, value2, this.myCurrentComplexTypeName, this.myCurrentComplexTypeNsName);
            } else if (this.myCurrentSimpleTypeName != null && this.myInsideRestriction) {
                this.putTypeDataToMap(nsURI, value2, this.myCurrentSimpleTypeName, this.myCurrentSimpleTypeNsName);
            }
        } else if (!this.myInsideSchema && ("name".equals(key2) || "ref".equals(key2))) {
            if (!(!SIGN.equals(this.myCurrentElementName) || this.myInsideContent || this.myInsideExtension || this.myInsideRestriction || this.myInsideSchema || this.myCurrentComplexTypeName != null || this.myCurrentSimpleTypeName != null)) {
                this.myCurrentElementName = value2;
            } else if (!(!SIGN.equals(this.myCurrentComplexTypeName) || this.myInsideContent || this.myInsideExtension || this.myInsideRestriction || this.myInsideSchema || this.myCurrentSimpleTypeName != null)) {
                this.myCurrentComplexTypeName = value2;
            } else if (!(!SIGN.equals(this.myCurrentSimpleTypeName) || this.myInsideContent || this.myInsideExtension || this.myInsideRestriction || this.myInsideSchema || this.myCurrentComplexTypeName != null)) {
                this.myCurrentSimpleTypeName = value2;
            }
        }
    }

    private void putTypeDataToMap(String nsURI, String value2, String typeName, String typeNamespace) {
        boolean isAnonymous = SIGN.equals(typeName);
        if (isAnonymous && this.myCurrentElementName != null) {
            this.myMap.putValue((Object)this.createSchemaTypeInfo(value2, true), (Object)this.createSchemaTypeInfo(this.myCurrentElementName, false));
        } else {
            this.myMap.putValue((Object)this.createSchemaTypeInfo(value2, true), (Object)this.createSchemaTypeInfo(typeName, true));
        }
    }

    private SchemaTypeInfo createSchemaTypeInfo(String value2, boolean isType) {
        int separatorIdx = value2.indexOf(58);
        String ns = separatorIdx <= 0 ? SIGN : value2.substring(0, separatorIdx);
        String element = separatorIdx <= 0 ? value2 : value2.substring(separatorIdx + 1);
        String nsUri = this.myNameSpaceHelper.getNamespaces().get(ns);
        nsUri = nsUri == null ? ns : nsUri;
        return new SchemaTypeInfo(element, isType, nsUri);
    }

    private static class NameSpaceHelper
    extends NanoXmlUtil.EmptyValidator {
        public static final String XMLNS = "xmlns";
        public static final String XMLNS_ = "xmlns:";
        private boolean myInSchema;
        private final Map<String, String> myNamespaces = new HashMap();

        private NameSpaceHelper() {
        }

        public void attributeAdded(String key2, String value2, String systemId, int lineNr) {
            super.attributeAdded(key2, value2, systemId, lineNr);
            if (this.myInSchema && key2.startsWith(XMLNS)) {
                if (key2.length() == XMLNS.length()) {
                    this.myNamespaces.put(XsdComplexTypeInfoBuilder.SIGN, value2);
                } else if (key2.startsWith(XMLNS_)) {
                    String prefix = key2.substring(XMLNS_.length());
                    this.myNamespaces.put(prefix, value2);
                }
            }
        }

        public void elementStarted(String name2, String systemId, int lineNr) {
            super.elementStarted(name2, systemId, lineNr);
            this.myInSchema = "schema".equals(name2) || name2.endsWith(":schema");
        }

        public Map<String, String> getNamespaces() {
            return this.myNamespaces;
        }
    }
}

