/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.util.documentation.CompositeAttributeTagDescriptor;
import com.intellij.xml.util.documentation.HtmlAttributeDescriptor;
import com.intellij.xml.util.documentation.HtmlTagDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

public class HtmlDescriptorsTable {
    public static final Logger LOG = Logger.getInstance(HtmlDescriptorsTable.class);
    private static final HashMap<String, HtmlTagDescriptor> ourTagTable = new HashMap();
    private static final HashMap<String, HtmlAttributeDescriptor> ourAttributeTable = new HashMap();
    @NonNls
    public static final String HTMLTABLE_RESOURCE_NAME = "htmltable.xml";
    @NonNls
    public static final String HTML5TABLE_RESOURCE_NAME = "html5table.xml";
    @NonNls
    private static final String MATHML_RESOURCE_NAME = "mathmltable.xml";
    @NonNls
    private static final String SVG_RESOURCE_NAME = "svgtable.xml";
    @NonNls
    public static final String TAG_ELEMENT_NAME = "tag";
    @NonNls
    public static final String BASE_HELP_REF_ATTR = "baseHelpRef";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    public static final String HELPREF_ATTR = "helpref";
    @NonNls
    public static final String DESCRIPTION_ATTR = "description";
    @NonNls
    public static final String STARTTAG_ATTR = "startTag";
    @NonNls
    public static final String ENDTAG_ATTR = "endTag";
    @NonNls
    public static final String EMPTY_ATTR = "empty";
    @NonNls
    public static final String DTD_ATTR = "dtd";
    @NonNls
    public static final String ATTRIBUTE_ELEMENT_NAME = "attribute";
    @NonNls
    public static final String TYPE_ATTR = "type";
    @NonNls
    public static final String DEFAULT_ATTR = "default";
    @NonNls
    public static final String RELATED_TAGS_ATTR = "relatedTags";

    private HtmlDescriptorsTable() {
    }

    private static void loadHtmlElements(String resourceName, Collection<String> htmlTagNames) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument((InputStream)HtmlDescriptorsTable.class.getResourceAsStream(resourceName));
        List elements = document.getRootElement().getChildren(TAG_ELEMENT_NAME);
        String baseHtmlExtDocUrl = document.getRootElement().getAttribute(BASE_HELP_REF_ATTR).getValue();
        for (Object object : elements) {
            Element element = (Element)object;
            String htmlTagName = element.getAttributeValue(NAME_ATTR);
            htmlTagNames.add(htmlTagName);
            HtmlTagDescriptor value2 = new HtmlTagDescriptor();
            ourTagTable.put(htmlTagName, value2);
            value2.setHelpRef(baseHtmlExtDocUrl + element.getAttributeValue(HELPREF_ATTR));
            value2.setDescription(element.getAttributeValue(DESCRIPTION_ATTR));
            value2.setName(htmlTagName);
            value2.setHasStartTag(element.getAttribute(STARTTAG_ATTR).getBooleanValue());
            value2.setHasEndTag(element.getAttribute(ENDTAG_ATTR).getBooleanValue());
            value2.setEmpty(element.getAttribute(EMPTY_ATTR).getBooleanValue());
            String attributeValue = element.getAttributeValue(DTD_ATTR);
            if (attributeValue.length() <= 0) continue;
            value2.setDtd(attributeValue.charAt(0));
        }
        List attributes = document.getRootElement().getChildren(ATTRIBUTE_ELEMENT_NAME);
        for (Object attribute : attributes) {
            Element element = (Element)attribute;
            String attrName = element.getAttributeValue(NAME_ATTR);
            HtmlAttributeDescriptor value3 = new HtmlAttributeDescriptor();
            HtmlAttributeDescriptor previousDescriptor = ourAttributeTable.get(attrName);
            if (previousDescriptor == null) {
                ourAttributeTable.put(attrName, value3);
            } else {
                CompositeAttributeTagDescriptor parentDescriptor;
                if (!(previousDescriptor instanceof CompositeAttributeTagDescriptor)) {
                    parentDescriptor = new CompositeAttributeTagDescriptor();
                    ourAttributeTable.put(attrName, parentDescriptor);
                    parentDescriptor.attributes.add(previousDescriptor);
                } else {
                    parentDescriptor = (CompositeAttributeTagDescriptor)previousDescriptor;
                }
                parentDescriptor.attributes.add(value3);
            }
            value3.setHelpRef(element.getAttributeValue(HELPREF_ATTR));
            value3.setDescription(element.getAttributeValue(DESCRIPTION_ATTR));
            value3.setName(attrName);
            String attributeValue = element.getAttributeValue(DTD_ATTR);
            if (attributeValue.length() > 0) {
                value3.setDtd(attributeValue.charAt(0));
            }
            value3.setType(element.getAttributeValue(TYPE_ATTR));
            value3.setHasDefaultValue(element.getAttribute(DEFAULT_ATTR).getBooleanValue());
            StringTokenizer tokenizer = new StringTokenizer(element.getAttributeValue(RELATED_TAGS_ATTR), ",");
            int tokenCount = tokenizer.countTokens();
            for (int i = 0; i < tokenCount; ++i) {
                String s = tokenizer.nextToken();
                if (s.equals("!")) {
                    value3.setParentSetIsExclusionSet(true);
                    continue;
                }
                if (value3.getSetOfParentTags() == null) {
                    value3.setSetOfParentTags(new String[tokenCount - (value3.isParentSetIsExclusionSet() ? 1 : 0)]);
                }
                value3.getSetOfParentTags()[i - (value3.isParentSetIsExclusionSet() ? 1 : 0)] = s;
            }
            Arrays.sort(value3.getSetOfParentTags());
        }
    }

    public static HtmlTagDescriptor getTagDescriptor(String tagName) {
        return ourTagTable.get(tagName);
    }

    public static HtmlAttributeDescriptor getAttributeDescriptor(String attributeName) {
        return ourAttributeTable.get(attributeName);
    }

    static {
        try {
            HashSet htmlTagNames = new HashSet();
            HtmlDescriptorsTable.loadHtmlElements(HTMLTABLE_RESOURCE_NAME, (Collection<String>)htmlTagNames);
            HtmlDescriptorsTable.loadHtmlElements(HTML5TABLE_RESOURCE_NAME, (Collection<String>)htmlTagNames);
            HtmlDescriptorsTable.loadHtmlElements(MATHML_RESOURCE_NAME, (Collection<String>)htmlTagNames);
            HtmlDescriptorsTable.loadHtmlElements(SVG_RESOURCE_NAME, (Collection<String>)htmlTagNames);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }
}

