/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JsonSchemaType {
    _string,
    _number,
    _integer,
    _object,
    _array,
    _boolean,
    _null,
    _any;


    public String getName() {
        return this.name().substring(1);
    }

    @Nullable
    static JsonSchemaType getType(@NotNull JsonValueAdapter value2) {
        if (value2 == null) {
            JsonSchemaType.$$$reportNull$$$0(0);
        }
        if (value2.isNull()) {
            return _null;
        }
        if (value2.isBooleanLiteral()) {
            return _boolean;
        }
        if (value2.isStringLiteral()) {
            return _string;
        }
        if (value2.isArray()) {
            return _array;
        }
        if (value2.isObject()) {
            return _object;
        }
        if (value2.isNumberLiteral()) {
            return JsonSchemaType.isInteger(value2.getDelegate().getText()) ? _integer : _number;
        }
        return null;
    }

    private static boolean isInteger(@NotNull String text2) {
        if (text2 == null) {
            JsonSchemaType.$$$reportNull$$$0(1);
        }
        try {
            Integer.parseInt(text2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInteger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

