/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

class ParameterClassCheckVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiParameter parameter;
    private boolean checked;

    ParameterClassCheckVisitor(@NotNull PsiParameter parameter2) {
        if (parameter2 == null) {
            ParameterClassCheckVisitor.$$$reportNull$$$0(0);
        }
        this.parameter = parameter2;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            ParameterClassCheckVisitor.$$$reportNull$$$0(1);
        }
        if (!this.checked) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
        if (expression2 == null) {
            ParameterClassCheckVisitor.$$$reportNull$$$0(2);
        }
        if (this.checked) {
            return;
        }
        super.visitMethodCallExpression(expression2);
        if (this.isGetClassCall(expression2) || this.isGetInstanceCall(expression2) || this.isCallToSuperEquals(expression2)) {
            this.checked = true;
        }
    }

    private boolean isGetInstanceCall(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"isInstance".equals(methodName)) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (!"java.lang.Class".equals(className)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (expressions2.length != 1) {
            return false;
        }
        PsiExpression expression2 = expressions2[0];
        return this.isParameterReference(expression2);
    }

    private boolean isGetClassCall(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"getClass".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 0) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (!"java.lang.Object".equals(className)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        return this.isParameterReference(qualifier);
    }

    private boolean isCallToSuperEquals(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
        if (!(qualifierExpression2 instanceof PsiSuperExpression)) {
            return false;
        }
        String name2 = methodExpression.getReferenceName();
        if (!"equals".equals(name2)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            return false;
        }
        PsiExpression argument = arguments[0];
        if (!(argument instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
        PsiElement target2 = referenceExpression.resolve();
        return this.parameter.equals(target2);
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression2) {
        if (expression2 == null) {
            ParameterClassCheckVisitor.$$$reportNull$$$0(3);
        }
        if (this.checked) {
            return;
        }
        super.visitInstanceOfExpression(expression2);
        PsiExpression operand2 = expression2.getOperand();
        if (this.isParameterReference(operand2)) {
            this.checked = true;
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        if (this.checked) {
            return;
        }
        super.visitTypeCastExpression(expression2);
        PsiExpression operand2 = expression2.getOperand();
        if (!this.isParameterReference(operand2)) {
            return;
        }
        PsiTryStatement statement2 = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiTryStatement.class);
        if (statement2 == null) {
            return;
        }
        PsiParameter[] parameters2 = statement2.getCatchBlockParameters();
        if (parameters2.length < 2) {
            return;
        }
        boolean nullPointerExceptionFound = false;
        boolean classCastExceptionFound = false;
        for (PsiParameter parameter2 : parameters2) {
            PsiType type2 = parameter2.getType();
            if (type2.equalsToText("java.lang.NullPointerException")) {
                nullPointerExceptionFound = true;
                if (!classCastExceptionFound) continue;
                break;
            }
            if (!type2.equalsToText("java.lang.ClassCastException")) continue;
            classCastExceptionFound = true;
            if (nullPointerExceptionFound) break;
        }
        if (classCastExceptionFound && nullPointerExceptionFound) {
            this.checked = true;
        }
    }

    private boolean isParameterReference(PsiExpression operand2) {
        if (operand2 == null) {
            return false;
        }
        if (!(operand2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression expression2 = (PsiReferenceExpression)operand2;
        PsiElement referent = expression2.resolve();
        return referent != null && referent.equals(this.parameter);
    }

    public boolean isChecked() {
        return this.checked;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/bugs/ParameterClassCheckVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInstanceOfExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

