/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IteratorUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopConditionNotUpdatedInsideLoopInspection
extends BaseInspection {
    public boolean ignoreIterators = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("loop.condition.not.updated.inside.loop.display.name", new Object[0]);
        if (string == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean entireCondition = (Boolean)infos[0];
        if (entireCondition) {
            String string = InspectionGadgetsBundle.message("loop.condition.not.updated.inside.loop.problem.descriptor", new Object[0]);
            if (string == null) {
                LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("loop.variable.not.updated.inside.loop.problem.descriptor", new Object[0]);
        if (string == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.iterator.loop.variables", new Object[0]), (InspectionProfileEntry)this, "ignoreIterators");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopConditionNotUpdatedInsideLoopVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class LoopConditionNotUpdatedInsideLoopVisitor
    extends BaseInspectionVisitor {
        private LoopConditionNotUpdatedInsideLoopVisitor() {
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            this.check(condition2, (PsiStatement)statement2);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
            super.visitDoWhileStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            this.check(condition2, (PsiStatement)statement2);
        }

        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            this.check(condition2, (PsiStatement)statement2);
        }

        private void check(PsiExpression condition2, PsiStatement statement2) {
            SmartList notUpdated = new SmartList();
            if (this.checkCondition(condition2, statement2, (List<PsiExpression>)notUpdated)) {
                if (notUpdated.isEmpty()) {
                    if (!BoolUtils.isTrue(condition2)) {
                        this.registerError((PsiElement)condition2, Boolean.TRUE);
                    }
                } else {
                    for (PsiExpression expression2 : notUpdated) {
                        this.registerError((PsiElement)expression2, Boolean.FALSE);
                    }
                }
            }
        }

        private boolean checkCondition(@Nullable PsiExpression condition2, @NotNull PsiStatement context, List<PsiExpression> notUpdated) {
            if (context == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(0);
            }
            if (condition2 == null) {
                return false;
            }
            if (PsiUtil.isConstantExpression((PsiExpression)condition2) || ExpressionUtils.isNullLiteral(condition2)) {
                return true;
            }
            if (condition2 instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)condition2;
                PsiExpression operand2 = instanceOfExpression.getOperand();
                return this.checkCondition(operand2, context, notUpdated);
            }
            if (condition2 instanceof PsiParenthesizedExpression) {
                PsiExpression expression2 = ((PsiParenthesizedExpression)condition2).getExpression();
                return this.checkCondition(expression2, context, notUpdated);
            }
            if (condition2 instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
                for (PsiExpression operand3 : polyadicExpression.getOperands()) {
                    if (this.checkCondition(operand3, context, notUpdated)) continue;
                    return false;
                }
                return true;
            }
            if (condition2 instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)condition2;
                PsiElement element = referenceExpression.resolve();
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    PsiType type2 = field.getType();
                    if (field.hasModifierProperty("final") && type2.getArrayDimensions() == 0) {
                        if (field.hasModifierProperty("static")) {
                            return true;
                        }
                        PsiExpression qualifier = referenceExpression.getQualifierExpression();
                        if (qualifier == null) {
                            return true;
                        }
                        if (this.checkCondition(qualifier, context, notUpdated)) {
                            return true;
                        }
                    }
                } else if (element instanceof PsiVariable) {
                    PsiVariable variable = (PsiVariable)element;
                    if (variable.hasModifierProperty("final")) {
                        return true;
                    }
                    if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                        PsiType type3 = variable.getType();
                        if (!(VariableAccessUtils.variableIsAssigned(variable, (PsiElement)context) || type3 instanceof PsiArrayType && VariableAccessUtils.arrayContentsAreAssigned(variable, (PsiElement)context))) {
                            notUpdated.add((PsiExpression)referenceExpression);
                            return true;
                        }
                    }
                }
            } else if (condition2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition2;
                IElementType tokenType = prefixExpression.getOperationTokenType();
                if (JavaTokenType.EXCL.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType) || JavaTokenType.MINUS.equals(tokenType)) {
                    PsiExpression operand4 = prefixExpression.getOperand();
                    return this.checkCondition(operand4, context, notUpdated);
                }
            } else {
                if (condition2 instanceof PsiArrayAccessExpression) {
                    PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)condition2;
                    PsiExpression indexExpression = accessExpression.getIndexExpression();
                    return this.checkCondition(indexExpression, context, notUpdated) && this.checkCondition(accessExpression.getArrayExpression(), context, notUpdated);
                }
                if (condition2 instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)condition2;
                    PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
                    if (thenExpression2 == null || elseExpression2 == null) {
                        return false;
                    }
                    return this.checkCondition(conditionalExpression.getCondition(), context, notUpdated) && this.checkCondition(thenExpression2, context, notUpdated) && this.checkCondition(elseExpression2, context, notUpdated);
                }
                if (condition2 instanceof PsiThisExpression) {
                    return true;
                }
                if (condition2 instanceof PsiMethodCallExpression && !LoopConditionNotUpdatedInsideLoopInspection.this.ignoreIterators) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)condition2;
                    if (!IteratorUtils.isCallToHasNext(methodCallExpression)) {
                        return false;
                    }
                    PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                    PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
                    if (qualifierExpression2 instanceof PsiReferenceExpression) {
                        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
                        PsiElement element = referenceExpression.resolve();
                        if (!(element instanceof PsiVariable)) {
                            return false;
                        }
                        PsiVariable variable = (PsiVariable)element;
                        if (!IteratorUtils.containsCallToScannerNext((PsiElement)context, variable, true)) {
                            notUpdated.add(qualifierExpression2);
                            return true;
                        }
                    } else if (!IteratorUtils.containsCallToScannerNext((PsiElement)context, null, true)) {
                        notUpdated.add((PsiExpression)methodCallExpression);
                        return true;
                    }
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection$LoopConditionNotUpdatedInsideLoopVisitor", "checkCondition"));
        }
    }
}

