/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementWithTooFewBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 2;
    public int m_limit = 2;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.display.name", new Object[0]);
        if (string == null) {
            SwitchStatementWithTooFewBranchesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.min.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.problem.descriptor", branchCount);
        if (string == null) {
            SwitchStatementWithTooFewBranchesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithTooFewBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SwitchStatementWithTooFewBranchesVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithTooFewBranchesVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            int branchCountIncludingDefault;
            int branchCount;
            if (statement2 == null) {
                SwitchStatementWithTooFewBranchesVisitor.$$$reportNull$$$0(0);
            }
            if ((branchCount = SwitchUtils.calculateBranchCount(statement2)) == 0) {
                return;
            }
            int n = branchCountIncludingDefault = branchCount < 0 ? -branchCount + 1 : branchCount;
            if (branchCountIncludingDefault >= SwitchStatementWithTooFewBranchesInspection.this.m_limit) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, branchCountIncludingDefault);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection$SwitchStatementWithTooFewBranchesVisitor", "visitSwitchStatement"));
        }
    }
}

