/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.dataflow.ReuseOfLocalVariableInspectionBase;
import com.siyeh.ig.psiutils.HighlightUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ReuseOfLocalVariableInspection
extends ReuseOfLocalVariableInspectionBase {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReuseOfLocalVariableFix();
    }

    private static class ReuseOfLocalVariableFix
    extends InspectionGadgetsFix {
        private ReuseOfLocalVariableFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("reuse.of.local.variable.split.quickfix", new Object[0]);
            if (string == null) {
                ReuseOfLocalVariableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)descriptor2.getPsiElement();
            PsiLocalVariable variable = (PsiLocalVariable)referenceExpression.resolve();
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)referenceExpression.getParent();
            assert (assignment != null);
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)assignment.getParent();
            PsiExpression lExpression = assignment.getLExpression();
            String originalVariableName = lExpression.getText();
            assert (variable != null);
            PsiType type2 = variable.getType();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            PsiCodeBlock variableBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            String newVariableName = codeStyleManager.suggestUniqueVariableName(originalVariableName, (PsiElement)variableBlock, false);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)assignmentStatement, PsiCodeBlock.class);
            Object scope = codeBlock != null ? new LocalSearchScope((PsiElement)codeBlock) : variable.getUseScope();
            Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)scope, (boolean)false);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = psiFacade.getElementFactory();
            ArrayList<PsiReferenceExpression> collectedReferences = new ArrayList<PsiReferenceExpression>();
            for (PsiReference reference : query) {
                PsiElement referenceElement = reference.getElement();
                if (referenceElement == null) continue;
                TextRange textRange = assignmentStatement.getTextRange();
                if (referenceElement.getTextOffset() <= textRange.getEndOffset()) continue;
                PsiExpression newExpression = factory.createExpressionFromText(newVariableName, referenceElement);
                PsiReferenceExpression replacementExpression = (PsiReferenceExpression)referenceElement.replace((PsiElement)newExpression);
                collectedReferences.add(replacementExpression);
            }
            PsiExpression rhs = assignment.getRExpression();
            String rhsText = rhs == null ? "" : rhs.getText();
            String newStatementText = type2.getCanonicalText() + ' ' + newVariableName + " =  " + rhsText + ';';
            PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)assignmentStatement);
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)assignmentStatement.replace((PsiElement)newStatement);
            PsiElement[] elements = declarationStatement.getDeclaredElements();
            PsiLocalVariable newVariable = (PsiLocalVariable)elements[0];
            PsiElement context = declarationStatement.getParent();
            HighlightUtils.showRenameTemplate(context, (PsiNameIdentifierOwner)newVariable, (PsiReference[])collectedReferences.toArray(new PsiReferenceExpression[collectedReferences.size()]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection$ReuseOfLocalVariableFix", "getFamilyName"));
        }
    }
}

