/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.errorhandling.UnnecessaryInitCauseInspectionBase;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryInitCauseInspection
extends UnnecessaryInitCauseInspectionBase
implements CleanupLocalInspectionTool {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryInitCauseFix();
    }

    private static class UnnecessaryInitCauseFix
    extends InspectionGadgetsFix {
        private UnnecessaryInitCauseFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.initcause.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryInitCauseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement().getParent().getParent();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression argument = ExpressionUtils.getFirstExpressionInList(argumentList);
            if (argument == null) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier == null) {
                return;
            }
            PsiNewExpression newExpression = UnnecessaryInitCauseInspectionBase.findNewExpression(qualifier);
            if (newExpression == null) {
                return;
            }
            PsiExpressionList argumentList1 = newExpression.getArgumentList();
            if (argumentList1 == null) {
                return;
            }
            PsiElement newElement = argumentList1.add((PsiElement)argument);
            HighlightUtils.highlightElement(newElement);
            PsiElement parent = methodCallExpression.getParent();
            if (parent instanceof PsiExpressionStatement) {
                parent.delete();
            } else {
                methodCallExpression.replace((PsiElement)qualifier);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/UnnecessaryInitCauseInspection$UnnecessaryInitCauseFix", "getFamilyName"));
        }
    }
}

