/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.exceptions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryStatementWithMultipleResourcesInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("try.statement.with.multiple.resources.name", new Object[0]);
        if (string == null) {
            TryStatementWithMultipleResourcesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            TryStatementWithMultipleResourcesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SplitTryWithResourcesVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SplitTryWithResourcesFix();
    }

    private static void doFixImpl(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiCatchSection[] catchSections;
        PsiTryStatement tryStatement;
        PsiResourceList resourceList;
        if (element == null) {
            TryStatementWithMultipleResourcesInspection.$$$reportNull$$$0(2);
        }
        if ((resourceList = (tryStatement = (PsiTryStatement)element.getParent()).getResourceList()) == null || resourceList.getResourceVariablesCount() <= 1) {
            return;
        }
        StringBuilder newTryStatementText = new StringBuilder();
        int count = 0;
        for (PsiResourceListElement resource : resourceList) {
            if (count > 0) {
                newTryStatementText.append("{\n");
            }
            ++count;
            newTryStatementText.append("try (").append(resource.getText()).append(")");
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        newTryStatementText.append(tryBlock.getText());
        for (int i = 1; i < count; ++i) {
            newTryStatementText.append("\n}");
        }
        for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
            newTryStatementText.append(catchSection.getText());
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            newTryStatementText.append("finally").append(finallyBlock.getText());
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)tryStatement, newTryStatementText.toString());
    }

    private static boolean isAcceptable(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiTryStatement)) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        return resourceList.getResourceVariablesCount() > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/exceptions/TryStatementWithMultipleResourcesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/exceptions/TryStatementWithMultipleResourcesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doFixImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SplitTryWithResourcesFix
    extends InspectionGadgetsFix {
        private SplitTryWithResourcesFix() {
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) {
            TryStatementWithMultipleResourcesInspection.doFixImpl(descriptor2.getPsiElement());
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("try.statement.with.multiple.resources.quickfix", new Object[0]);
            if (string == null) {
                SplitTryWithResourcesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/exceptions/TryStatementWithMultipleResourcesInspection$SplitTryWithResourcesFix", "getFamilyName"));
        }
    }

    private static class SplitTryWithResourcesVisitor
    extends BaseInspectionVisitor {
        private SplitTryWithResourcesVisitor() {
        }

        public void visitKeyword(PsiKeyword keyword) {
            super.visitKeyword(keyword);
            if (this.isOnTheFly() && keyword.getTokenType() == JavaTokenType.TRY_KEYWORD && TryStatementWithMultipleResourcesInspection.isAcceptable((PsiElement)keyword)) {
                this.registerError((PsiElement)keyword, new Object[0]);
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            super.visitResourceList(resourceList);
            if (TryStatementWithMultipleResourcesInspection.isAcceptable((PsiElement)resourceList)) {
                this.registerError((PsiElement)resourceList, new Object[0]);
            }
        }
    }
}

