/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantMethodOverrideInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.method.override.display.name", new Object[0]);
        if (string == null) {
            RedundantMethodOverrideInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.method.override.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantMethodOverrideInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantMethodOverrideFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantMethodOverrideVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RedundantMethodOverrideVisitor
    extends BaseInspectionVisitor {
        private RedundantMethodOverrideVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod == null) {
                return;
            }
            if (!MethodUtils.haveEquivalentModifierLists(method, superMethod)) {
                return;
            }
            PsiType superReturnType = superMethod.getReturnType();
            if (superReturnType == null || !superReturnType.equals(method.getReturnType())) {
                return;
            }
            ParameterEquivalenceChecker checker = new ParameterEquivalenceChecker(method, superMethod);
            PsiCodeBlock superBody = superMethod.getBody();
            if (checker.codeBlocksAreEquivalent(body2, superBody) || this.isSuperCallWithSameArguments(body2, method, superMethod)) {
                this.registerMethodError(method, new Object[0]);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isSuperCallWithSameArguments(PsiCodeBlock body2, PsiMethod method, PsiMethod superMethod) {
            PsiExpression expression2;
            PsiStatement[] statements = body2.getStatements();
            if (statements.length != 1) {
                return false;
            }
            PsiStatement statement2 = statements[0];
            if (PsiType.VOID.equals((Object)method.getReturnType())) {
                if (!(statement2 instanceof PsiExpressionStatement)) return false;
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
                expression2 = expressionStatement.getExpression();
            } else {
                if (!(statement2 instanceof PsiReturnStatement)) return false;
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
                expression2 = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
            }
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            if (!MethodCallUtils.isSuperMethodCall(methodCallExpression, method)) {
                return false;
            }
            if (!superMethod.hasModifierProperty("protected")) return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method);
            PsiJavaFile file2 = (PsiJavaFile)method.getContainingFile();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)method.getProject()).findPackage(file2.getPackageName());
            if (aPackage == null) {
                return false;
            }
            PackageScope scope = new PackageScope(aPackage, false, false);
            if (this.isOnTheFly()) {
                PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)method.getProject());
                PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(method.getName(), (GlobalSearchScope)scope, null, null);
                if (cost == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                    return true;
                }
                if (cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return false;
                }
            }
            Query search2 = ReferencesSearch.search((PsiElement)method, (SearchScope)scope);
            PsiClass containingClass = method.getContainingClass();
            for (PsiReference reference : search2) {
                if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)reference.getElement(), (boolean)true)) continue;
                return false;
            }
            return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method);
        }

        private static boolean areSameArguments(PsiMethodCallExpression methodCallExpression, PsiMethod method) {
            PsiParameter[] parameters2;
            PsiExpression[] arguments = methodCallExpression.getArgumentList().getExpressions();
            if (arguments.length != (parameters2 = method.getParameterList().getParameters()).length) {
                return false;
            }
            for (int i = 0; i < arguments.length; ++i) {
                PsiExpression argument = arguments[i];
                PsiExpression exp = PsiUtil.deparenthesizeExpression((PsiExpression)argument);
                if (!(exp instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiElement resolved = ((PsiReferenceExpression)exp).resolve();
                if (method.getManager().areElementsEquivalent((PsiElement)parameters2[i], resolved)) continue;
                return false;
            }
            return true;
        }

        private static class ParameterEquivalenceChecker
        extends EquivalenceChecker {
            private final PsiMethod myMethod;
            private final PsiMethod mySuperMethod;

            ParameterEquivalenceChecker(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
                if (method == null) {
                    ParameterEquivalenceChecker.$$$reportNull$$$0(0);
                }
                if (superMethod == null) {
                    ParameterEquivalenceChecker.$$$reportNull$$$0(1);
                }
                this.myMethod = method;
                this.mySuperMethod = superMethod;
            }

            @Override
            protected EquivalenceChecker.Match referenceExpressionsMatch(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
                if (this.areSameParameters(referenceExpression1, referenceExpression2)) {
                    return EXACT_MATCH;
                }
                return super.referenceExpressionsMatch(referenceExpression1, referenceExpression2);
            }

            private boolean areSameParameters(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
                int index2;
                PsiElement scope2;
                PsiElement resolved1 = referenceExpression1.resolve();
                PsiElement resolved2 = referenceExpression2.resolve();
                if (!(resolved1 instanceof PsiParameter) || !(resolved2 instanceof PsiParameter)) {
                    return false;
                }
                PsiElement scope1 = ((PsiParameter)resolved1).getDeclarationScope();
                if (scope1 == (scope2 = ((PsiParameter)resolved2).getDeclarationScope()) || scope1 != this.myMethod && scope1 != this.mySuperMethod || scope2 != this.myMethod && scope2 != this.mySuperMethod) {
                    return false;
                }
                PsiElement parent1 = resolved1.getParent();
                PsiElement parent2 = resolved2.getParent();
                if (!(parent1 instanceof PsiParameterList) || !(parent2 instanceof PsiParameterList)) {
                    return false;
                }
                int index1 = ((PsiParameterList)parent1).getParameterIndex((PsiParameter)resolved1);
                return index1 == (index2 = ((PsiParameterList)parent2).getParameterIndex((PsiParameter)resolved2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "superMethod";
                        break;
                    }
                }
                objectArray[1] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideVisitor$ParameterEquivalenceChecker";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class RedundantMethodOverrideFix
    extends InspectionGadgetsFix {
        private RedundantMethodOverrideFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.method.override.quickfix", new Object[0]);
            if (string == null) {
                RedundantMethodOverrideFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor2) {
            PsiElement methodNameIdentifier = descriptor2.getPsiElement();
            PsiElement method = methodNameIdentifier.getParent();
            assert (method != null);
            RedundantMethodOverrideFix.deleteElement(method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideFix", "getFamilyName"));
        }
    }
}

