/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryJavaDocLinkInspection
extends BaseInspection {
    private static final int THIS_METHOD = 1;
    private static final int THIS_CLASS = 2;
    private static final int SUPER_METHOD = 3;
    public boolean ignoreInlineLinkToSuper = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryJavaDocLinkInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        int n = (Integer)infos[1];
        if (n == 1) {
            String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.this.method.problem.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryJavaDocLinkInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (n == 2) {
            String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.this.class.problem.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryJavaDocLinkInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.super.method.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryJavaDocLinkInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.javadoc.link.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInlineLinkToSuper");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryJavaDocLinkFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryJavaDocLinkVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javadoc/UnnecessaryJavaDocLinkInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryJavaDocLinkVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryJavaDocLinkVisitor() {
        }

        public void visitDocTag(PsiDocTag tag) {
            super.visitDocTag(tag);
            String name2 = tag.getName();
            if ("link".equals(name2) || "linkplain".equals(name2) ? !(tag instanceof PsiInlineDocTag) : "see".equals(name2) && tag instanceof PsiInlineDocTag) {
                return;
            }
            PsiReference reference = this.extractReference(tag);
            if (reference == null) {
                return;
            }
            PsiElement target2 = reference.resolve();
            if (target2 == null) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiMethod.class);
            if (containingMethod == null) {
                return;
            }
            if (target2.equals(containingMethod)) {
                this.registerError(tag.getNameElement(), '@' + name2, 1);
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiClass.class);
            if (target2.equals(containingClass)) {
                this.registerError(tag.getNameElement(), '@' + name2, 2);
                return;
            }
            if (!(target2 instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)target2;
            if (!this.isSuperMethod(method, containingMethod)) {
                return;
            }
            if (UnnecessaryJavaDocLinkInspection.this.ignoreInlineLinkToSuper && tag instanceof PsiInlineDocTag) {
                return;
            }
            this.registerError(tag.getNameElement(), '@' + name2, 3);
        }

        private PsiReference extractReference(PsiDocTag tag) {
            PsiDocTagValue valueElement = tag.getValueElement();
            if (valueElement != null) {
                return valueElement.getReference();
            }
            PsiElement[] dataElements = tag.getDataElements();
            if (dataElements.length == 0) {
                return null;
            }
            PsiElement salientElement = null;
            for (PsiElement dataElement : dataElements) {
                if (dataElement instanceof PsiWhiteSpace) continue;
                salientElement = dataElement;
                break;
            }
            if (salientElement == null) {
                return null;
            }
            PsiElement child = salientElement.getFirstChild();
            if (!(child instanceof PsiReference)) {
                return null;
            }
            return (PsiReference)child;
        }

        public boolean isSuperMethod(PsiMethod superMethodCandidate, PsiMethod derivedMethod) {
            PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
            PsiClass derivedClass = derivedMethod.getContainingClass();
            if (derivedClass == null || superClassCandidate == null) {
                return false;
            }
            if (!derivedClass.isInheritor(superClassCandidate, false)) {
                return false;
            }
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClassCandidate, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
            MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
            return MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)derivedSignature);
        }
    }

    private static class UnnecessaryJavaDocLinkFix
    extends InspectionGadgetsFix {
        private final String tagName;

        public UnnecessaryJavaDocLinkFix(String tagName) {
            this.tagName = tagName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.quickfix", this.tagName);
            if (string == null) {
                UnnecessaryJavaDocLinkFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove redundant tag" == null) {
                UnnecessaryJavaDocLinkFix.$$$reportNull$$$0(1);
            }
            return "Remove redundant tag";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiDocTag)) {
                return;
            }
            PsiDocTag docTag = (PsiDocTag)parent;
            PsiDocComment docComment = docTag.getContainingComment();
            if (docComment != null && UnnecessaryJavaDocLinkFix.shouldDeleteEntireComment(docComment)) {
                docComment.delete();
                return;
            }
            docTag.delete();
        }

        private static boolean shouldDeleteEntireComment(PsiDocComment docComment) {
            PsiDocToken[] docTokens = (PsiDocToken[])PsiTreeUtil.getChildrenOfType((PsiElement)docComment, PsiDocToken.class);
            if (docTokens == null) {
                return false;
            }
            for (PsiDocToken docToken : docTokens) {
                IElementType tokenType = docToken.getTokenType();
                if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType) || StringUtil.isEmptyOrSpaces((String)docToken.getText())) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/javadoc/UnnecessaryJavaDocLinkInspection$UnnecessaryJavaDocLinkFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

