/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class EnumAsNameInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("EnumAsIdentifier" == null) {
            EnumAsNameInspectionBase.$$$reportNull$$$0(0);
        }
        return "EnumAsIdentifier";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.enum.as.identifier.display.name", new Object[0]);
        if (string == null) {
            EnumAsNameInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.enum.as.identifier.problem.descriptor", new Object[0]);
        if (string == null) {
            EnumAsNameInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EnumAsNameVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/jdk/EnumAsNameInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EnumAsNameVisitor
    extends BaseInspectionVisitor {
        private EnumAsNameVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                EnumAsNameVisitor.$$$reportNull$$$0(0);
            }
            super.visitVariable(variable);
            String variableName = variable.getName();
            if (!"enum".equals(variableName)) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                EnumAsNameVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethod(method);
            String name2 = method.getName();
            if (!"enum".equals(name2)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            String name2;
            if (aClass == null) {
                EnumAsNameVisitor.$$$reportNull$$$0(2);
            }
            if (!"enum".equals(name2 = aClass.getName())) {
                return;
            }
            PsiTypeParameterList params = aClass.getTypeParameterList();
            if (params != null) {
                params.accept((PsiElementVisitor)this);
            }
            this.registerClassError(aClass, new Object[0]);
        }

        public void visitTypeParameter(PsiTypeParameter parameter2) {
            super.visitTypeParameter(parameter2);
            String name2 = parameter2.getName();
            if (!"enum".equals(name2)) {
                return;
            }
            this.registerTypeParameterError(parameter2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/jdk/EnumAsNameInspectionBase$EnumAsNameVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

