/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseWithNoTestMethodsInspection
extends BaseInspection {
    public boolean ignoreSupers = true;

    @NotNull
    public String getID() {
        if ("JUnitTestCaseWithNoTests" == null) {
            TestCaseWithNoTestMethodsInspection.$$$reportNull$$$0(0);
        }
        return "JUnitTestCaseWithNoTests";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.case.with.no.test.methods.display.name", new Object[0]);
        if (string == null) {
            TestCaseWithNoTestMethodsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.case.with.no.test.methods.problem.descriptor", new Object[0]);
        if (string == null) {
            TestCaseWithNoTestMethodsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("test.case.with.no.test.methods.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSupers");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseWithNoTestMethodsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/TestCaseWithNoTestMethodsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class TestCaseWithNoTestMethodsVisitor
    extends BaseInspectionVisitor {
        private TestCaseWithNoTestMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass superClass;
            PsiMethod[] methods;
            if (aClass == null) {
                TestCaseWithNoTestMethodsVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType() || aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"junit.framework.TestCase")) {
                return;
            }
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!TestUtils.isJUnitTestMethod(method)) continue;
                return;
            }
            if (TestCaseWithNoTestMethodsInspection.this.ignoreSupers && (superClass = aClass.getSuperClass()) != null) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = superClass.getMethods()) {
                    if (!TestUtils.isJUnitTestMethod(superMethod)) continue;
                    return;
                }
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/junit/TestCaseWithNoTestMethodsInspection$TestCaseWithNoTestMethodsVisitor", "visitClass"));
        }
    }
}

