/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogStatementGuardedByLogConditionInspectionBase
extends BaseInspection {
    final List<String> logMethodNameList = new ArrayList<String>();
    final List<String> logConditionMethodNameList = new ArrayList<String>();
    public String loggerClassName = "java.util.logging.Logger";
    @NonNls
    public String loggerMethodAndconditionMethodNames = "fine,isLoggable(java.util.logging.Level.FINE),finer,isLoggable(java.util.logging.Level.FINER),finest,isLoggable(java.util.logging.Level.FINEST)";
    public boolean flagAllUnguarded = false;

    public LogStatementGuardedByLogConditionInspectionBase() {
        LogStatementGuardedByLogConditionInspectionBase.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.display.name", new Object[0]);
        if (string == null) {
            LogStatementGuardedByLogConditionInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            LogStatementGuardedByLogConditionInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LogStatementGuardedByLogConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LogStatementGuardedByLogConditionVisitor();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            LogStatementGuardedByLogConditionInspectionBase.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        LogStatementGuardedByLogConditionInspectionBase.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            LogStatementGuardedByLogConditionInspectionBase.$$$reportNull$$$0(3);
        }
        this.loggerMethodAndconditionMethodNames = LogStatementGuardedByLogConditionInspectionBase.formatString(this.logMethodNameList, this.logConditionMethodNameList);
        super.writeSettings(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LogStatementGuardedByLogConditionVisitor
    extends BaseInspectionVisitor {
        private LogStatementGuardedByLogConditionVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!LogStatementGuardedByLogConditionInspectionBase.this.logMethodNameList.contains(referenceName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspectionBase.this.loggerClassName)) {
                return;
            }
            if (this.isSurroundedByLogGuard((PsiElement)expression2, referenceName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            if (!LogStatementGuardedByLogConditionInspectionBase.this.flagAllUnguarded) {
                boolean constant = true;
                for (PsiExpression argument : arguments) {
                    if (PsiUtil.isConstantExpression((PsiExpression)argument)) continue;
                    constant = false;
                    break;
                }
                if (constant) {
                    return;
                }
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private boolean isSurroundedByLogGuard(PsiElement element, String logMethodName) {
            PsiIfStatement ifStatement;
            while ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) != null) {
                PsiExpression condition2 = ifStatement.getCondition();
                if (this.isLogGuardCheck(condition2, logMethodName)) {
                    return true;
                }
                element = ifStatement;
            }
            return false;
        }

        private boolean isLogGuardCheck(@Nullable PsiExpression expression2, String logMethodName) {
            if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspectionBase.this.loggerClassName)) {
                    return false;
                }
                String referenceName = methodExpression.getReferenceName();
                if (referenceName == null) {
                    return false;
                }
                int index = LogStatementGuardedByLogConditionInspectionBase.this.logMethodNameList.indexOf(logMethodName);
                String conditionName = LogStatementGuardedByLogConditionInspectionBase.this.logConditionMethodNameList.get(index);
                return conditionName.startsWith(referenceName);
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                PsiExpression[] operands2;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    if (!this.isLogGuardCheck(operand2, logMethodName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class LogStatementGuardedByLogConditionFix
    extends InspectionGadgetsFix {
        private LogStatementGuardedByLogConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.quickfix", new Object[0]);
            if (string == null) {
                LogStatementGuardedByLogConditionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element.getParent().getParent();
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiStatement.class);
            if (statement2 == null) {
                return;
            }
            ArrayList<PsiStatement> logStatements = new ArrayList<PsiStatement>();
            logStatements.add(statement2);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement2, PsiStatement.class);
            while (previousStatement != null && this.isSameLogMethodCall(previousStatement, referenceName)) {
                logStatements.add(0, previousStatement);
                previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)previousStatement, PsiStatement.class);
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
            while (nextStatement != null && this.isSameLogMethodCall(nextStatement, referenceName)) {
                logStatements.add(nextStatement);
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            int index = LogStatementGuardedByLogConditionInspectionBase.this.logMethodNameList.indexOf(referenceName);
            String conditionMethodText = LogStatementGuardedByLogConditionInspectionBase.this.logConditionMethodNameList.get(index);
            String ifStatementText = "if (" + qualifier.getText() + '.' + conditionMethodText + ") {}";
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(ifStatementText, (PsiElement)statement2);
            PsiBlockStatement blockStatement = (PsiBlockStatement)ifStatement.getThenBranch();
            if (blockStatement == null) {
                return;
            }
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            for (PsiStatement logStatement : logStatements) {
                codeBlock.add((PsiElement)logStatement);
            }
            PsiStatement firstStatement = (PsiStatement)logStatements.get(0);
            PsiElement parent = firstStatement.getParent();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getElseBranch() != null) {
                PsiBlockStatement newBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)statement2);
                newBlockStatement.getCodeBlock().add((PsiElement)ifStatement);
                PsiElement result2 = firstStatement.replace((PsiElement)newBlockStatement);
                codeStyleManager.shortenClassReferences(result2);
                return;
            }
            PsiElement result3 = parent.addBefore((PsiElement)ifStatement, (PsiElement)firstStatement);
            codeStyleManager.shortenClassReferences(result3);
            for (PsiStatement logStatement : logStatements) {
                logStatement.delete();
            }
        }

        private boolean isSameLogMethodCall(PsiStatement statement2, @NotNull String methodName) {
            if (methodName == null) {
                LogStatementGuardedByLogConditionFix.$$$reportNull$$$0(1);
            }
            if (statement2 == null) {
                return false;
            }
            if (!(statement2 instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!methodName.equals(referenceName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return qualifier != null && TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspectionBase.this.loggerClassName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase$LogStatementGuardedByLogConditionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase$LogStatementGuardedByLogConditionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSameLogMethodCall";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

