/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TryWithIdenticalCatchesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("try.with.identical.catches.problem.descriptor", type2.getPresentableText());
        if (string == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("try.with.identical.catches.display.name", new Object[0]);
        if (string == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file2);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        PsiCatchSection catchSection;
        PsiParameter parameter2;
        if (element == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiCatchSection && (parameter2 = (catchSection = (PsiCatchSection)element).getParameter()) != null && super.isSuppressedFor((PsiElement)parameter2)) {
            return true;
        }
        return super.isSuppressedFor(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryWithIdenticalCatchesVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseCatchSectionsFix((Integer)infos[1], (Integer)infos[2]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollapseCatchSectionsFix
    extends InspectionGadgetsFix {
        private final int myCollapseIntoIndex;
        private final int mySectionIndex;

        public CollapseCatchSectionsFix(int collapseIntoIndex, int sectionIndex) {
            this.myCollapseIntoIndex = collapseIntoIndex;
            this.mySectionIndex = sectionIndex;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("try.with.identical.catches.quickfix", new Object[0]);
            if (string == null) {
                CollapseCatchSectionsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiType type2;
            PsiTryStatement tryStatement = (PsiTryStatement)descriptor2.getPsiElement().getParent();
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            if (this.myCollapseIntoIndex >= catchSections.length || this.mySectionIndex >= catchSections.length) {
                return;
            }
            PsiCatchSection collapseInto = catchSections[this.myCollapseIntoIndex];
            PsiCatchSection section = catchSections[this.mySectionIndex];
            PsiParameter parameter1 = collapseInto.getParameter();
            PsiParameter parameter2 = section.getParameter();
            if (parameter1 == null || parameter2 == null) {
                return;
            }
            PsiType type1 = parameter1.getType();
            if (TypeConversionUtil.isAssignable((PsiType)type1, (PsiType)(type2 = parameter2.getType()))) {
                section.delete();
                return;
            }
            if (TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)type1)) {
                collapseInto.delete();
                return;
            }
            ArrayList<PsiType> types = new ArrayList<PsiType>();
            CollapseCatchSectionsFix.collectDisjunctTypes(type1, types);
            CollapseCatchSectionsFix.collectDisjunctTypes(type2, types);
            StringBuilder typeText = new StringBuilder();
            for (PsiType type3 : types) {
                if (typeText.length() > 0) {
                    typeText.append(" | ");
                }
                typeText.append(type3.getCanonicalText());
            }
            PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)project2).createTypeElementFromText(typeText.toString(), (PsiElement)tryStatement);
            PsiTypeElement typeElement = parameter1.getTypeElement();
            if (typeElement == null) {
                return;
            }
            typeElement.replace((PsiElement)newTypeElement);
            section.delete();
        }

        private static void collectDisjunctTypes(PsiType type2, List<PsiType> out) {
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                List disjunctions = disjunctionType.getDisjunctions();
                for (PsiType disjunction : disjunctions) {
                    CollapseCatchSectionsFix.collectDisjunctTypes(disjunction, out);
                }
                return;
            }
            Iterator<PsiType> iterator = out.iterator();
            while (iterator.hasNext()) {
                PsiType collectedType = iterator.next();
                if (TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)collectedType)) {
                    iterator.remove();
                    continue;
                }
                if (!TypeConversionUtil.isAssignable((PsiType)collectedType, (PsiType)type2)) continue;
                return;
            }
            out.add(type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$CollapseCatchSectionsFix", "getFamilyName"));
        }
    }

    private static class TryWithIdenticalCatchesVisitor
    extends BaseInspectionVisitor {
        private TryWithIdenticalCatchesVisitor() {
        }

        public void visitTryStatement(PsiTryStatement statement2) {
            super.visitTryStatement(statement2);
            PsiCatchSection[] catchSections = statement2.getCatchSections();
            if (catchSections.length < 2) {
                return;
            }
            PsiParameter[] parameters2 = statement2.getCatchBlockParameters();
            if (catchSections.length != parameters2.length) {
                return;
            }
            boolean[] duplicates = new boolean[catchSections.length];
            for (int i = 0; i < catchSections.length - 1; ++i) {
                PsiParameter parameter2;
                PsiCatchSection catchSection = catchSections[i];
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (catchBlock == null || (parameter2 = catchSection.getParameter()) == null) continue;
                DuplicatesFinder finder = TryWithIdenticalCatchesVisitor.buildDuplicatesFinder(catchBlock, parameter2);
                for (int j = i + 1; j < catchSections.length; ++j) {
                    DuplicatesFinder reverseFinder;
                    Match otherMatch;
                    Match match;
                    PsiParameter otherParameter;
                    PsiCatchSection otherSection;
                    PsiCodeBlock otherCatchBlock;
                    if (duplicates[j] || (otherCatchBlock = (otherSection = catchSections[j]).getCatchBlock()) == null || (otherParameter = otherSection.getParameter()) == null || (match = finder.isDuplicate((PsiElement)otherCatchBlock, true)) == null || (otherMatch = (reverseFinder = TryWithIdenticalCatchesVisitor.buildDuplicatesFinder(otherCatchBlock, otherParameter)).isDuplicate((PsiElement)catchBlock, true)) == null) continue;
                    ReturnValue returnValue = match.getReturnValue();
                    ReturnValue otherReturnValue = otherMatch.getReturnValue();
                    if ((returnValue != null ? !returnValue.isEquivalent(otherReturnValue) : otherReturnValue != null) || (j <= i ? !TryWithIdenticalCatchesVisitor.canCollapse(parameters2, j, i) : !TryWithIdenticalCatchesVisitor.canCollapse(parameters2, i, j))) continue;
                    PsiJavaToken rParenth = otherSection.getRParenth();
                    if (rParenth != null) {
                        this.registerErrorAtOffset((PsiElement)otherSection, 0, rParenth.getStartOffsetInParent() + 1, catchSection.getParameter().getType(), i, j);
                    }
                    duplicates[i] = true;
                    duplicates[j] = true;
                }
            }
        }

        private static DuplicatesFinder buildDuplicatesFinder(@NotNull PsiCodeBlock catchBlock, @NotNull PsiParameter parameter2) {
            if (catchBlock == null) {
                TryWithIdenticalCatchesVisitor.$$$reportNull$$$0(0);
            }
            if (parameter2 == null) {
                TryWithIdenticalCatchesVisitor.$$$reportNull$$$0(1);
            }
            InputVariables inputVariables = new InputVariables(Collections.singletonList(parameter2), parameter2.getProject(), new LocalSearchScope((PsiElement)catchBlock), false);
            return new DuplicatesFinder(new PsiElement[]{catchBlock}, inputVariables, null, Collections.emptyList());
        }

        private static boolean canCollapse(PsiParameter[] parameters2, int index1, int index2) {
            if (index2 <= index1) {
                throw new IllegalArgumentException();
            }
            PsiType type2 = parameters2[index2].getType();
            for (int i = index1 + 1; i < index2; ++i) {
                PsiType otherType = parameters2[i].getType();
                if (!TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)otherType)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "catchBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$TryWithIdenticalCatchesVisitor";
            objectArray[2] = "buildDuplicatesFinder";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

