/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BooleanMethodNameMustStartWithQuestionInspectionBase
extends BaseInspection {
    public static final String DEFAULT_QUESTION_WORDS = "add,are,can,check,contains,could,endsWith,equals,has,is,matches,must,put,remove,shall,should,startsWith,was,were,will,would";
    public boolean ignoreBooleanMethods = false;
    public boolean ignoreInAnnotationInterface = true;
    public boolean onlyWarnOnBaseMethods = true;
    @NonNls
    public String questionString = "add,are,can,check,contains,could,endsWith,equals,has,is,matches,must,put,remove,shall,should,startsWith,was,were,will,would";
    List<String> questionList = new ArrayList<String>(32);

    public BooleanMethodNameMustStartWithQuestionInspectionBase() {
        BooleanMethodNameMustStartWithQuestionInspectionBase.parseString(this.questionString, this.questionList);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.display.name", new Object[0]);
        if (string == null) {
            BooleanMethodNameMustStartWithQuestionInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.problem.descriptor", new Object[0]);
        if (string == null) {
            BooleanMethodNameMustStartWithQuestionInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            BooleanMethodNameMustStartWithQuestionInspectionBase.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        BooleanMethodNameMustStartWithQuestionInspectionBase.parseString(this.questionString, this.questionList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            BooleanMethodNameMustStartWithQuestionInspectionBase.$$$reportNull$$$0(3);
        }
        this.questionString = BooleanMethodNameMustStartWithQuestionInspectionBase.formatString(this.questionList);
        super.writeSettings(element);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanMethodNameMustStartWithQuestionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BooleanMethodNameMustStartWithQuestionVisitor
    extends BaseInspectionVisitor {
        private BooleanMethodNameMustStartWithQuestionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass containingClass;
            PsiType returnType;
            if (method == null) {
                BooleanMethodNameMustStartWithQuestionVisitor.$$$reportNull$$$0(0);
            }
            if ((returnType = method.getReturnType()) == null) {
                return;
            }
            if (!(returnType.equals(PsiType.BOOLEAN) || !BooleanMethodNameMustStartWithQuestionInspectionBase.this.ignoreBooleanMethods && returnType.equalsToText("java.lang.Boolean"))) {
                return;
            }
            if (BooleanMethodNameMustStartWithQuestionInspectionBase.this.ignoreInAnnotationInterface && (containingClass = method.getContainingClass()) != null && containingClass.isAnnotationType()) {
                return;
            }
            String name2 = method.getName();
            for (String question : BooleanMethodNameMustStartWithQuestionInspectionBase.this.questionList) {
                if (!name2.startsWith(question)) continue;
                return;
            }
            if (BooleanMethodNameMustStartWithQuestionInspectionBase.this.onlyWarnOnBaseMethods ? MethodUtils.hasSuper(method) : LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspectionBase$BooleanMethodNameMustStartWithQuestionVisitor", "visitMethod"));
        }
    }
}

