/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class ParameterNameDiffersFromOverriddenParameterInspectionBase
extends BaseInspection {
    public boolean m_ignoreSingleCharacterNames = false;
    public boolean m_ignoreOverridesOfLibraryMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.display.name", new Object[0]);
        if (string == null) {
            ParameterNameDiffersFromOverriddenParameterInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.problem.descriptor", infos[0]);
        if (string == null) {
            ParameterNameDiffersFromOverriddenParameterInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterNameDiffersFromOverriddenParameterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ParameterNameDiffersFromOverriddenParameterVisitor
    extends BaseInspectionVisitor {
        private ParameterNameDiffersFromOverriddenParameterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameterList parameterList;
            if (method == null) {
                ParameterNameDiffersFromOverriddenParameterVisitor.$$$reportNull$$$0(0);
            }
            if ((parameterList = method.getParameterList()).getParametersCount() == 0) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod == null) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            this.checkParameters(superMethod, parameters2);
        }

        private void checkParameters(@NotNull PsiMethod superMethod, PsiParameter[] parameters2) {
            PsiClass containingClass;
            if (superMethod == null) {
                ParameterNameDiffersFromOverriddenParameterVisitor.$$$reportNull$$$0(1);
            }
            if (ParameterNameDiffersFromOverriddenParameterInspectionBase.this.m_ignoreOverridesOfLibraryMethods && (containingClass = superMethod.getContainingClass()) != null && LibraryUtil.classIsInLibrary(containingClass)) {
                return;
            }
            PsiParameterList superParameterList = superMethod.getParameterList();
            PsiParameter[] superParameters = superParameterList.getParameters();
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                String parameterName = parameter2.getName();
                String superParameterName = superParameters[i].getName();
                if (superParameterName == null || superParameterName.equals(parameterName) || ParameterNameDiffersFromOverriddenParameterInspectionBase.this.m_ignoreSingleCharacterNames && superParameterName.length() == 1) continue;
                this.registerVariableError((PsiVariable)parameter2, superParameterName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superMethod";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspectionBase$ParameterNameDiffersFromOverriddenParameterVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

