/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedNumberConstructorCallInspection
extends BaseInspection {
    static final Set<String> cachedNumberTypes = new HashSet<String>();
    public boolean ignoreStringArguments = false;
    public boolean reportOnlyWhenDeprecated = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cached.number.constructor.call.display.name", new Object[0]);
        if (string == null) {
            CachedNumberConstructorCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("cached.number.constructor.call.problem.descriptor", new Object[0]);
        if (string == null) {
            CachedNumberConstructorCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("cached.number.constructor.call.ignore.string.arguments.option", new Object[0]), "ignoreStringArguments");
        panel2.addCheckbox(InspectionGadgetsBundle.message("cached.number.constructor.call.report.only.deprecated", new Object[0]), "reportOnlyWhenDeprecated");
        return panel2;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LongConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiNewExpression expression2 = (PsiNewExpression)infos[0];
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
        assert (classReference2 != null);
        String className = classReference2.getText();
        return new CachedNumberConstructorCallFix(className);
    }

    static {
        cachedNumberTypes.add("java.lang.Long");
        cachedNumberTypes.add("java.lang.Byte");
        cachedNumberTypes.add("java.lang.Integer");
        cachedNumberTypes.add("java.lang.Short");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class LongConstructorVisitor
    extends BaseInspectionVisitor {
        private LongConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                LongConstructorVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            String canonicalText = type2.getCanonicalText();
            if (!cachedNumberTypes.contains(canonicalText)) {
                return;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)expression2);
            if (aClass != null && cachedNumberTypes.contains(aClass.getQualifiedName())) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null || CachedNumberConstructorCallInspection.this.ignoreStringArguments && argumentType.equalsToText("java.lang.String")) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null || CachedNumberConstructorCallInspection.this.reportOnlyWhenDeprecated && !method.isDeprecated()) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection$LongConstructorVisitor", "visitNewExpression"));
        }
    }

    private static class CachedNumberConstructorCallFix
    extends InspectionGadgetsFix {
        private final String className;

        CachedNumberConstructorCallFix(String className) {
            this.className = className;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("cached.number.constructor.call.quickfix", this.className);
            if (string == null) {
                CachedNumberConstructorCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with '.valueOf' call" == null) {
                CachedNumberConstructorCallFix.$$$reportNull$$$0(1);
            }
            return "Replace with '.valueOf' call";
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiNewExpression expression2 = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), PsiNewExpression.class, (boolean)false);
            assert (expression2 != null);
            PsiExpressionList argList = expression2.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            PsiExpression arg = args[0];
            String text2 = arg.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, this.className + ".valueOf(" + text2 + ')');
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection$CachedNumberConstructorCallFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

