/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

class ConvertOctalLiteralToDecimalFix
extends InspectionGadgetsFix {
    ConvertOctalLiteralToDecimalFix() {
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("convert.octal.literal.to.decimal.literal.quickfix", new Object[0]);
        if (string == null) {
            ConvertOctalLiteralToDecimalFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor2) {
        PsiElement element = descriptor2.getPsiElement();
        if (!(element instanceof PsiLiteralExpression)) {
            return;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
        ConvertOctalLiteralToDecimalFix.replaceWithDecimalLiteral(literalExpression);
    }

    static void replaceWithDecimalLiteral(PsiLiteralExpression literalExpression) {
        Object value2 = literalExpression.getValue();
        if (value2 == null) {
            return;
        }
        String decimalText = value2 + (PsiType.LONG.equals((Object)literalExpression.getType()) ? "L" : "");
        PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, decimalText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConvertOctalLiteralToDecimalFix", "getFamilyName"));
    }
}

