/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualsToEqualityFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectEqualsCanBeEqualityInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.equals.can.be.equality.display.name", new Object[0]);
        if (string == null) {
            ObjectEqualsCanBeEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean negated = (Boolean)infos[0];
        String string = negated != false ? InspectionGadgetsBundle.message("object.equals.can.be.equality.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("not.object.equals.can.be.equality.problem.descriptor", new Object[0]);
        if (string == null) {
            ObjectEqualsCanBeEqualityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean not = (Boolean)infos[0];
        return new EqualsToEqualityFix(not);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualsMayBeEqualityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/ObjectEqualsCanBeEqualityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ObjectEqualsMayBeEqualityVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualsMayBeEqualityVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isEqualsCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiExpression[] expressions2 = expression2.getArgumentList().getExpressions();
            if (expressions2.length != 1) {
                return;
            }
            PsiExpression argument = expressions2[0];
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)JavaTokenType.EQEQ, (PsiExpression)qualifier, (PsiExpression)argument, (boolean)false)) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
            ProblemHighlightType highlightType = ClassUtils.isFinalClassWithDefaultEquals(aClass) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            boolean negated = parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
            PsiElement nameToken = methodExpression.getReferenceNameElement();
            assert (nameToken != null);
            this.registerError(nameToken, highlightType, new Object[]{negated});
        }
    }
}

